/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class QueryFeatureExtractor
implements JsonpSerializable {
    @Nullable
    private final Float defaultScore;
    private final String featureName;
    private final Query query;
    public static final JsonpDeserializer<QueryFeatureExtractor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, QueryFeatureExtractor::setupQueryFeatureExtractorDeserializer);

    private QueryFeatureExtractor(Builder builder) {
        this.defaultScore = builder.defaultScore;
        this.featureName = ApiTypeHelper.requireNonNull(builder.featureName, this, "featureName");
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
    }

    public static QueryFeatureExtractor of(Function<Builder, ObjectBuilder<QueryFeatureExtractor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Float defaultScore() {
        return this.defaultScore;
    }

    public final String featureName() {
        return this.featureName;
    }

    public final Query query() {
        return this.query;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.defaultScore != null) {
            generator.writeKey("default_score");
            generator.write(this.defaultScore.floatValue());
        }
        generator.writeKey("feature_name");
        generator.write(this.featureName);
        generator.writeKey("query");
        this.query.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupQueryFeatureExtractorDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::defaultScore, JsonpDeserializer.floatDeserializer(), "default_score");
        op.add(Builder::featureName, JsonpDeserializer.stringDeserializer(), "feature_name");
        op.add(Builder::query, Query._DESERIALIZER, "query");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<QueryFeatureExtractor> {
        @Nullable
        private Float defaultScore;
        private String featureName;
        private Query query;

        public final Builder defaultScore(@Nullable Float value) {
            this.defaultScore = value;
            return this;
        }

        public final Builder featureName(String value) {
            this.featureName = value;
            return this;
        }

        public final Builder query(Query value) {
            this.query = value;
            return this;
        }

        public final Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public final Builder query(QueryVariant value) {
            this.query = value._toQuery();
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public QueryFeatureExtractor build() {
            this._checkSingleUse();
            return new QueryFeatureExtractor(this);
        }
    }
}

