/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class KeyValueProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final List<String> excludeKeys;
    private final String field;
    private final String fieldSplit;
    @Nullable
    private final Boolean ignoreMissing;
    private final List<String> includeKeys;
    @Nullable
    private final String prefix;
    @Nullable
    private final Boolean stripBrackets;
    @Nullable
    private final String targetField;
    @Nullable
    private final String trimKey;
    @Nullable
    private final String trimValue;
    private final String valueSplit;
    public static final JsonpDeserializer<KeyValueProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KeyValueProcessor::setupKeyValueProcessorDeserializer);

    private KeyValueProcessor(Builder builder) {
        super(builder);
        this.excludeKeys = ApiTypeHelper.unmodifiable(builder.excludeKeys);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.fieldSplit = ApiTypeHelper.requireNonNull(builder.fieldSplit, this, "fieldSplit");
        this.ignoreMissing = builder.ignoreMissing;
        this.includeKeys = ApiTypeHelper.unmodifiable(builder.includeKeys);
        this.prefix = builder.prefix;
        this.stripBrackets = builder.stripBrackets;
        this.targetField = builder.targetField;
        this.trimKey = builder.trimKey;
        this.trimValue = builder.trimValue;
        this.valueSplit = ApiTypeHelper.requireNonNull(builder.valueSplit, this, "valueSplit");
    }

    public static KeyValueProcessor of(Function<Builder, ObjectBuilder<KeyValueProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Kv;
    }

    public final List<String> excludeKeys() {
        return this.excludeKeys;
    }

    public final String field() {
        return this.field;
    }

    public final String fieldSplit() {
        return this.fieldSplit;
    }

    @Nullable
    public final Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    public final List<String> includeKeys() {
        return this.includeKeys;
    }

    @Nullable
    public final String prefix() {
        return this.prefix;
    }

    @Nullable
    public final Boolean stripBrackets() {
        return this.stripBrackets;
    }

    @Nullable
    public final String targetField() {
        return this.targetField;
    }

    @Nullable
    public final String trimKey() {
        return this.trimKey;
    }

    @Nullable
    public final String trimValue() {
        return this.trimValue;
    }

    public final String valueSplit() {
        return this.valueSplit;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.excludeKeys)) {
            generator.writeKey("exclude_keys");
            generator.writeStartArray();
            for (String item0 : this.excludeKeys) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("field_split");
        generator.write(this.fieldSplit);
        if (this.ignoreMissing != null) {
            generator.writeKey("ignore_missing");
            generator.write(this.ignoreMissing);
        }
        if (ApiTypeHelper.isDefined(this.includeKeys)) {
            generator.writeKey("include_keys");
            generator.writeStartArray();
            for (String item0 : this.includeKeys) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.prefix != null) {
            generator.writeKey("prefix");
            generator.write(this.prefix);
        }
        if (this.stripBrackets != null) {
            generator.writeKey("strip_brackets");
            generator.write(this.stripBrackets);
        }
        if (this.targetField != null) {
            generator.writeKey("target_field");
            generator.write(this.targetField);
        }
        if (this.trimKey != null) {
            generator.writeKey("trim_key");
            generator.write(this.trimKey);
        }
        if (this.trimValue != null) {
            generator.writeKey("trim_value");
            generator.write(this.trimValue);
        }
        generator.writeKey("value_split");
        generator.write(this.valueSplit);
    }

    protected static void setupKeyValueProcessorDeserializer(ObjectDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::excludeKeys, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "exclude_keys");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::fieldSplit, JsonpDeserializer.stringDeserializer(), "field_split");
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing");
        op.add(Builder::includeKeys, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "include_keys");
        op.add(Builder::prefix, JsonpDeserializer.stringDeserializer(), "prefix");
        op.add(Builder::stripBrackets, JsonpDeserializer.booleanDeserializer(), "strip_brackets");
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field");
        op.add(Builder::trimKey, JsonpDeserializer.stringDeserializer(), "trim_key");
        op.add(Builder::trimValue, JsonpDeserializer.stringDeserializer(), "trim_value");
        op.add(Builder::valueSplit, JsonpDeserializer.stringDeserializer(), "value_split");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<KeyValueProcessor> {
        @Nullable
        private List<String> excludeKeys;
        private String field;
        private String fieldSplit;
        @Nullable
        private Boolean ignoreMissing;
        @Nullable
        private List<String> includeKeys;
        @Nullable
        private String prefix;
        @Nullable
        private Boolean stripBrackets;
        @Nullable
        private String targetField;
        @Nullable
        private String trimKey;
        @Nullable
        private String trimValue;
        private String valueSplit;

        public final Builder excludeKeys(List<String> list) {
            this.excludeKeys = Builder._listAddAll(this.excludeKeys, list);
            return this;
        }

        public final Builder excludeKeys(String value, String ... values) {
            this.excludeKeys = Builder._listAdd(this.excludeKeys, value, values);
            return this;
        }

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder fieldSplit(String value) {
            this.fieldSplit = value;
            return this;
        }

        public final Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        public final Builder includeKeys(List<String> list) {
            this.includeKeys = Builder._listAddAll(this.includeKeys, list);
            return this;
        }

        public final Builder includeKeys(String value, String ... values) {
            this.includeKeys = Builder._listAdd(this.includeKeys, value, values);
            return this;
        }

        public final Builder prefix(@Nullable String value) {
            this.prefix = value;
            return this;
        }

        public final Builder stripBrackets(@Nullable Boolean value) {
            this.stripBrackets = value;
            return this;
        }

        public final Builder targetField(@Nullable String value) {
            this.targetField = value;
            return this;
        }

        public final Builder trimKey(@Nullable String value) {
            this.trimKey = value;
            return this;
        }

        public final Builder trimValue(@Nullable String value) {
            this.trimValue = value;
            return this;
        }

        public final Builder valueSplit(String value) {
            this.valueSplit = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public KeyValueProcessor build() {
            this._checkSingleUse();
            return new KeyValueProcessor(this);
        }
    }
}

