/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch.inference.RateLimitSetting;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class AmazonBedrockServiceSettings
implements JsonpSerializable {
    private final String accessKey;
    private final String model;
    @Nullable
    private final String provider;
    private final String region;
    @Nullable
    private final RateLimitSetting rateLimit;
    private final String secretKey;
    public static final JsonpDeserializer<AmazonBedrockServiceSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AmazonBedrockServiceSettings::setupAmazonBedrockServiceSettingsDeserializer);

    private AmazonBedrockServiceSettings(Builder builder) {
        this.accessKey = ApiTypeHelper.requireNonNull(builder.accessKey, this, "accessKey");
        this.model = ApiTypeHelper.requireNonNull(builder.model, this, "model");
        this.provider = builder.provider;
        this.region = ApiTypeHelper.requireNonNull(builder.region, this, "region");
        this.rateLimit = builder.rateLimit;
        this.secretKey = ApiTypeHelper.requireNonNull(builder.secretKey, this, "secretKey");
    }

    public static AmazonBedrockServiceSettings of(Function<Builder, ObjectBuilder<AmazonBedrockServiceSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String accessKey() {
        return this.accessKey;
    }

    public final String model() {
        return this.model;
    }

    @Nullable
    public final String provider() {
        return this.provider;
    }

    public final String region() {
        return this.region;
    }

    @Nullable
    public final RateLimitSetting rateLimit() {
        return this.rateLimit;
    }

    public final String secretKey() {
        return this.secretKey;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("access_key");
        generator.write(this.accessKey);
        generator.writeKey("model");
        generator.write(this.model);
        if (this.provider != null) {
            generator.writeKey("provider");
            generator.write(this.provider);
        }
        generator.writeKey("region");
        generator.write(this.region);
        if (this.rateLimit != null) {
            generator.writeKey("rate_limit");
            this.rateLimit.serialize(generator, mapper);
        }
        generator.writeKey("secret_key");
        generator.write(this.secretKey);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupAmazonBedrockServiceSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::accessKey, JsonpDeserializer.stringDeserializer(), "access_key");
        op.add(Builder::model, JsonpDeserializer.stringDeserializer(), "model");
        op.add(Builder::provider, JsonpDeserializer.stringDeserializer(), "provider");
        op.add(Builder::region, JsonpDeserializer.stringDeserializer(), "region");
        op.add(Builder::rateLimit, RateLimitSetting._DESERIALIZER, "rate_limit");
        op.add(Builder::secretKey, JsonpDeserializer.stringDeserializer(), "secret_key");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<AmazonBedrockServiceSettings> {
        private String accessKey;
        private String model;
        @Nullable
        private String provider;
        private String region;
        @Nullable
        private RateLimitSetting rateLimit;
        private String secretKey;

        public final Builder accessKey(String value) {
            this.accessKey = value;
            return this;
        }

        public final Builder model(String value) {
            this.model = value;
            return this;
        }

        public final Builder provider(@Nullable String value) {
            this.provider = value;
            return this;
        }

        public final Builder region(String value) {
            this.region = value;
            return this;
        }

        public final Builder rateLimit(@Nullable RateLimitSetting value) {
            this.rateLimit = value;
            return this;
        }

        public final Builder rateLimit(Function<RateLimitSetting.Builder, ObjectBuilder<RateLimitSetting>> fn) {
            return this.rateLimit(fn.apply(new RateLimitSetting.Builder()).build());
        }

        public final Builder secretKey(String value) {
            this.secretKey = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AmazonBedrockServiceSettings build() {
            this._checkSingleUse();
            return new AmazonBedrockServiceSettings(this);
        }
    }
}

