/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.connector.UpdateApiKeyIdResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class UpdateApiKeyIdRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String apiKeyId;
    @Nullable
    private final String apiKeySecretId;
    private final String connectorId;
    public static final JsonpDeserializer<UpdateApiKeyIdRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateApiKeyIdRequest::setupUpdateApiKeyIdRequestDeserializer);
    public static final Endpoint<UpdateApiKeyIdRequest, UpdateApiKeyIdResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<UpdateApiKeyIdRequest, UpdateApiKeyIdResponse>("es/connector.update_api_key_id", request -> "PUT", request -> {
        boolean _connectorId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_connector");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.connectorId, buf);
            buf.append("/_api_key_id");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _connectorId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("connectorId", request.connectorId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, UpdateApiKeyIdResponse._DESERIALIZER);

    private UpdateApiKeyIdRequest(Builder builder) {
        this.apiKeyId = builder.apiKeyId;
        this.apiKeySecretId = builder.apiKeySecretId;
        this.connectorId = ApiTypeHelper.requireNonNull(builder.connectorId, this, "connectorId");
    }

    public static UpdateApiKeyIdRequest of(Function<Builder, ObjectBuilder<UpdateApiKeyIdRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String apiKeyId() {
        return this.apiKeyId;
    }

    @Nullable
    public final String apiKeySecretId() {
        return this.apiKeySecretId;
    }

    public final String connectorId() {
        return this.connectorId;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.apiKeyId != null) {
            generator.writeKey("api_key_id");
            generator.write(this.apiKeyId);
        }
        if (this.apiKeySecretId != null) {
            generator.writeKey("api_key_secret_id");
            generator.write(this.apiKeySecretId);
        }
    }

    protected static void setupUpdateApiKeyIdRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::apiKeyId, JsonpDeserializer.stringDeserializer(), "api_key_id");
        op.add(Builder::apiKeySecretId, JsonpDeserializer.stringDeserializer(), "api_key_secret_id");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<UpdateApiKeyIdRequest> {
        @Nullable
        private String apiKeyId;
        @Nullable
        private String apiKeySecretId;
        private String connectorId;

        public final Builder apiKeyId(@Nullable String value) {
            this.apiKeyId = value;
            return this;
        }

        public final Builder apiKeySecretId(@Nullable String value) {
            this.apiKeySecretId = value;
            return this;
        }

        public final Builder connectorId(String value) {
            this.connectorId = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UpdateApiKeyIdRequest build() {
            this._checkSingleUse();
            return new UpdateApiKeyIdRequest(this);
        }
    }
}

