/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.connector.DeleteConnectorResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class DeleteConnectorRequest
extends RequestBase {
    private final String connectorId;
    @Nullable
    private final Boolean deleteSyncJobs;
    public static final Endpoint<DeleteConnectorRequest, DeleteConnectorResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<DeleteConnectorRequest, DeleteConnectorResponse>("es/connector.delete", request -> "DELETE", request -> {
        boolean _connectorId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_connector");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.connectorId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _connectorId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("connectorId", request.connectorId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.deleteSyncJobs != null) {
            params.put("delete_sync_jobs", String.valueOf(request.deleteSyncJobs));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, DeleteConnectorResponse._DESERIALIZER);

    private DeleteConnectorRequest(Builder builder) {
        this.connectorId = ApiTypeHelper.requireNonNull(builder.connectorId, this, "connectorId");
        this.deleteSyncJobs = builder.deleteSyncJobs;
    }

    public static DeleteConnectorRequest of(Function<Builder, ObjectBuilder<DeleteConnectorRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String connectorId() {
        return this.connectorId;
    }

    @Nullable
    public final Boolean deleteSyncJobs() {
        return this.deleteSyncJobs;
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DeleteConnectorRequest> {
        private String connectorId;
        @Nullable
        private Boolean deleteSyncJobs;

        public final Builder connectorId(String value) {
            this.connectorId = value;
            return this;
        }

        public final Builder deleteSyncJobs(@Nullable Boolean value) {
            this.deleteSyncJobs = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DeleteConnectorRequest build() {
            this._checkSingleUse();
            return new DeleteConnectorRequest(this);
        }
    }
}

