/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class MutualInformationHeuristic
implements JsonpSerializable {
    @Nullable
    private final Boolean backgroundIsSuperset;
    @Nullable
    private final Boolean includeNegatives;
    public static final JsonpDeserializer<MutualInformationHeuristic> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MutualInformationHeuristic::setupMutualInformationHeuristicDeserializer);

    private MutualInformationHeuristic(Builder builder) {
        this.backgroundIsSuperset = builder.backgroundIsSuperset;
        this.includeNegatives = builder.includeNegatives;
    }

    public static MutualInformationHeuristic of(Function<Builder, ObjectBuilder<MutualInformationHeuristic>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean backgroundIsSuperset() {
        return this.backgroundIsSuperset;
    }

    @Nullable
    public final Boolean includeNegatives() {
        return this.includeNegatives;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.backgroundIsSuperset != null) {
            generator.writeKey("background_is_superset");
            generator.write(this.backgroundIsSuperset);
        }
        if (this.includeNegatives != null) {
            generator.writeKey("include_negatives");
            generator.write(this.includeNegatives);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupMutualInformationHeuristicDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::backgroundIsSuperset, JsonpDeserializer.booleanDeserializer(), "background_is_superset");
        op.add(Builder::includeNegatives, JsonpDeserializer.booleanDeserializer(), "include_negatives");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<MutualInformationHeuristic> {
        @Nullable
        private Boolean backgroundIsSuperset;
        @Nullable
        private Boolean includeNegatives;

        public final Builder backgroundIsSuperset(@Nullable Boolean value) {
            this.backgroundIsSuperset = value;
            return this;
        }

        public final Builder includeNegatives(@Nullable Boolean value) {
            this.includeNegatives = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MutualInformationHeuristic build() {
            this._checkSingleUse();
            return new MutualInformationHeuristic(this);
        }
    }
}

