/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GetStats
implements JsonpSerializable {
    private final long current;
    @Nullable
    private final Time existsTime;
    private final long existsTimeInMillis;
    private final long existsTotal;
    @Nullable
    private final Time missingTime;
    private final long missingTimeInMillis;
    private final long missingTotal;
    @Nullable
    private final Time time;
    private final long timeInMillis;
    private final long total;
    public static final JsonpDeserializer<GetStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetStats::setupGetStatsDeserializer);

    private GetStats(Builder builder) {
        this.current = ApiTypeHelper.requireNonNull(builder.current, (Object)this, "current", 0L);
        this.existsTime = builder.existsTime;
        this.existsTimeInMillis = ApiTypeHelper.requireNonNull(builder.existsTimeInMillis, (Object)this, "existsTimeInMillis", 0L);
        this.existsTotal = ApiTypeHelper.requireNonNull(builder.existsTotal, (Object)this, "existsTotal", 0L);
        this.missingTime = builder.missingTime;
        this.missingTimeInMillis = ApiTypeHelper.requireNonNull(builder.missingTimeInMillis, (Object)this, "missingTimeInMillis", 0L);
        this.missingTotal = ApiTypeHelper.requireNonNull(builder.missingTotal, (Object)this, "missingTotal", 0L);
        this.time = builder.time;
        this.timeInMillis = ApiTypeHelper.requireNonNull(builder.timeInMillis, (Object)this, "timeInMillis", 0L);
        this.total = ApiTypeHelper.requireNonNull(builder.total, (Object)this, "total", 0L);
    }

    public static GetStats of(Function<Builder, ObjectBuilder<GetStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long current() {
        return this.current;
    }

    @Nullable
    public final Time existsTime() {
        return this.existsTime;
    }

    public final long existsTimeInMillis() {
        return this.existsTimeInMillis;
    }

    public final long existsTotal() {
        return this.existsTotal;
    }

    @Nullable
    public final Time missingTime() {
        return this.missingTime;
    }

    public final long missingTimeInMillis() {
        return this.missingTimeInMillis;
    }

    public final long missingTotal() {
        return this.missingTotal;
    }

    @Nullable
    public final Time time() {
        return this.time;
    }

    public final long timeInMillis() {
        return this.timeInMillis;
    }

    public final long total() {
        return this.total;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("current");
        generator.write(this.current);
        if (this.existsTime != null) {
            generator.writeKey("exists_time");
            this.existsTime.serialize(generator, mapper);
        }
        generator.writeKey("exists_time_in_millis");
        generator.write(this.existsTimeInMillis);
        generator.writeKey("exists_total");
        generator.write(this.existsTotal);
        if (this.missingTime != null) {
            generator.writeKey("missing_time");
            this.missingTime.serialize(generator, mapper);
        }
        generator.writeKey("missing_time_in_millis");
        generator.write(this.missingTimeInMillis);
        generator.writeKey("missing_total");
        generator.write(this.missingTotal);
        if (this.time != null) {
            generator.writeKey("time");
            this.time.serialize(generator, mapper);
        }
        generator.writeKey("time_in_millis");
        generator.write(this.timeInMillis);
        generator.writeKey("total");
        generator.write(this.total);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupGetStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::current, JsonpDeserializer.longDeserializer(), "current");
        op.add(Builder::existsTime, Time._DESERIALIZER, "exists_time");
        op.add(Builder::existsTimeInMillis, JsonpDeserializer.longDeserializer(), "exists_time_in_millis");
        op.add(Builder::existsTotal, JsonpDeserializer.longDeserializer(), "exists_total");
        op.add(Builder::missingTime, Time._DESERIALIZER, "missing_time");
        op.add(Builder::missingTimeInMillis, JsonpDeserializer.longDeserializer(), "missing_time_in_millis");
        op.add(Builder::missingTotal, JsonpDeserializer.longDeserializer(), "missing_total");
        op.add(Builder::time, Time._DESERIALIZER, "time");
        op.add(Builder::timeInMillis, JsonpDeserializer.longDeserializer(), "time_in_millis");
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetStats> {
        private Long current;
        @Nullable
        private Time existsTime;
        private Long existsTimeInMillis;
        private Long existsTotal;
        @Nullable
        private Time missingTime;
        private Long missingTimeInMillis;
        private Long missingTotal;
        @Nullable
        private Time time;
        private Long timeInMillis;
        private Long total;

        public final Builder current(long value) {
            this.current = value;
            return this;
        }

        public final Builder existsTime(@Nullable Time value) {
            this.existsTime = value;
            return this;
        }

        public final Builder existsTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.existsTime(fn.apply(new Time.Builder()).build());
        }

        public final Builder existsTimeInMillis(long value) {
            this.existsTimeInMillis = value;
            return this;
        }

        public final Builder existsTotal(long value) {
            this.existsTotal = value;
            return this;
        }

        public final Builder missingTime(@Nullable Time value) {
            this.missingTime = value;
            return this;
        }

        public final Builder missingTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.missingTime(fn.apply(new Time.Builder()).build());
        }

        public final Builder missingTimeInMillis(long value) {
            this.missingTimeInMillis = value;
            return this;
        }

        public final Builder missingTotal(long value) {
            this.missingTotal = value;
            return this;
        }

        public final Builder time(@Nullable Time value) {
            this.time = value;
            return this;
        }

        public final Builder time(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.time(fn.apply(new Time.Builder()).build());
        }

        public final Builder timeInMillis(long value) {
            this.timeInMillis = value;
            return this;
        }

        public final Builder total(long value) {
            this.total = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetStats build() {
            this._checkSingleUse();
            return new GetStats(this);
        }
    }
}

