/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.dissect.search;

import org.logstash.dissect.search.DelimiterLocator;

public class MultiByteLocator
implements DelimiterLocator {
    public static final MultiByteLocator INSTANCE = new MultiByteLocator();

    private MultiByteLocator() {
    }

    @Override
    public final int indexOf(byte[] needle, byte[] haystack, int offset) {
        int localOffset = offset;
        int sourceCount = haystack.length;
        if (localOffset >= sourceCount) {
            return -1;
        }
        if (localOffset < 0) {
            localOffset = 0;
        }
        byte first = needle[0];
        int max = sourceCount - needle.length;
        for (int i = localOffset; i <= max; ++i) {
            if (haystack[i] != first) {
                while (++i <= max && haystack[i] != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + needle.length - 1;
            int k = 1;
            while (j < end && haystack[j] == needle[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }
}

