/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyEncoding;
import org.jruby.RubyString;
import org.jruby.platform.Platform;
import org.jruby.util.ByteList;
import org.jruby.util.FileResource;
import org.jruby.util.JRubyFile;
import org.jruby.util.StringSupport;

public class Dir {
    public static final boolean DOSISH = Platform.IS_WINDOWS;
    public static final boolean CASEFOLD_FILESYSTEM = DOSISH;
    public static final int FNM_NOESCAPE = 1;
    public static final int FNM_PATHNAME = 2;
    public static final int FNM_DOTMATCH = 4;
    public static final int FNM_CASEFOLD = 8;
    public static final int FNM_GLOB_SKIPDOT = 128;
    public static final int FNM_SYSCASE = CASEFOLD_FILESYSTEM ? 8 : 0;
    public static final int FNM_NOMATCH = 1;
    public static final int FNM_ERROR = 2;
    public static final byte[] EMPTY = ByteList.NULL_ARRAY;
    public static final byte[] SLASH = new byte[]{47};
    public static final byte[] STAR = new byte[]{42};
    public static final byte[] DOUBLE_STAR = new byte[]{42, 42};
    private static final GlobFunc<List<ByteList>> push_pattern = new GlobFunc<List<ByteList>>(){

        @Override
        public int call(byte[] ptr, int p2, int len, Encoding enc, List<ByteList> ary) {
            ary.add(new ByteList(ptr, p2, len, enc, true));
            return 0;
        }
    };
    private static final GlobFunc<GlobArgs> glob_caller = new GlobFunc<GlobArgs>(){

        @Override
        public int call(byte[] ptr, int p2, int len, Encoding enc, GlobArgs args2) {
            args2.c = p2;
            return args2.func.call(ptr, args2.c, len, enc, args2.arg);
        }
    };

    private static boolean isdirsep(int c) {
        return c == 47 || DOSISH && c == 92;
    }

    private static boolean isdirsep(byte c) {
        return Dir.isdirsep(c & 0xFF);
    }

    private static int rb_path_next(byte[] _s, int s2, int send2) {
        while (s2 < send2 && !Dir.isdirsep(_s[s2])) {
            ++s2;
        }
        return s2;
    }

    public static int fnmatch(byte[] bytes2, int pstart, int pend, byte[] string2, int sstart, int send2, int flags2) {
        return Dir.fnmatch(bytes2, pstart, pend, string2, sstart, send2, flags2, ASCIIEncoding.INSTANCE);
    }

    public static int fnmatch(byte[] bytes2, int pstart, int pend, byte[] string2, int sstart, int send2, int flags2, Encoding enc) {
        boolean period = (flags2 & 4) == 0;
        boolean pathname2 = (flags2 & 2) != 0;
        int pat_pos = pstart;
        int str_pos = sstart;
        int ptmp = -1;
        int stmp = -1;
        if (pathname2) {
            while (true) {
                FilenameMatch fnmatch2;
                if (Dir.isDoubleStarAndSlash(bytes2, pat_pos)) {
                    while (Dir.isDoubleStarAndSlash(bytes2, pat_pos += 3)) {
                    }
                    ptmp = pat_pos;
                    stmp = str_pos;
                }
                if ((fnmatch2 = new FilenameMatch(pat_pos, str_pos, flags2)).helper(bytes2, pend, string2, send2, enc) == 0) {
                    pat_pos = fnmatch2.pcur;
                    for (str_pos = fnmatch2.scur; str_pos < send2 && string2[str_pos] != 47; ++str_pos) {
                    }
                    if (pat_pos < pend && str_pos < send2) {
                        ++pat_pos;
                        ++str_pos;
                        continue;
                    }
                    if (pat_pos == pend && str_pos == send2) {
                        return 0;
                    }
                }
                if (ptmp == -1 || stmp == -1 || period && string2[stmp] == 46 || (stmp = Dir.nextSlashIndex(string2, stmp, send2)) >= send2) break;
                pat_pos = ptmp;
                str_pos = ++stmp;
            }
            return 1;
        }
        FilenameMatch fnmatch3 = new FilenameMatch(pstart, sstart, flags2);
        return fnmatch3.helper(bytes2, pend, string2, send2, enc);
    }

    private static boolean isDoubleStarAndSlash(byte[] bytes2, int pos2) {
        if (bytes2.length - pos2 <= 2) {
            return false;
        }
        return bytes2[pos2] == 42 && bytes2[pos2 + 1] == 42 && bytes2[pos2 + 2] == 47;
    }

    private static int nextSlashIndex(byte[] bytes2, int start2, int end2) {
        int idx;
        for (idx = start2; idx < end2 && idx < bytes2.length && bytes2[idx] != 47; ++idx) {
        }
        return idx;
    }

    public static List<ByteList> push_glob(Ruby runtime2, String cwd, ByteList globByteList, int flags2, boolean sort2) {
        if (globByteList.length() > 0) {
            ArrayList<ByteList> result2 = new ArrayList<ByteList>();
            Dir.push_braces(runtime2, cwd, result2, new GlobPattern(globByteList, flags2), sort2);
            return result2;
        }
        return Collections.emptyList();
    }

    private static int push_braces(Ruby runtime2, String cwd, List<ByteList> result2, GlobPattern pattern, boolean sort2) {
        pattern.reset();
        int lbrace = pattern.indexOf((byte)123);
        int rbrace = pattern.findClosingIndexOf(lbrace);
        if (lbrace == -1 || rbrace == -1 || lbrace > 0 && pattern.bytes[lbrace - 1] == 92 && (lbrace <= 1 || pattern.bytes[lbrace - 2] != 92) || rbrace > 0 && pattern.bytes[rbrace - 1] == 92 && (rbrace <= 1 || pattern.bytes[rbrace - 2] != 92)) {
            ByteList unescaped = new ByteList(pattern.bytes.length - 1);
            unescaped.setEncoding(pattern.enc);
            for (int i2 = pattern.begin; i2 < pattern.end; ++i2) {
                byte b2 = pattern.bytes[i2];
                if (b2 == 92 && i2 < pattern.bytes.length - 1) {
                    byte next_b = pattern.bytes[i2 + 1];
                    if (next_b == 123 || next_b == 125) continue;
                    unescaped.append(b2);
                    continue;
                }
                unescaped.append(b2);
            }
            return Dir.push_globs(runtime2, cwd, result2, unescaped, pattern.flags, sort2);
        }
        ByteList bytes2 = new ByteList(20);
        bytes2.setEncoding(pattern.enc);
        int i3 = lbrace;
        while (pattern.bytes[i3] != 125) {
            int middleRegionIndex;
            for (i3 = middleRegionIndex = i3 + 1; i3 < pattern.end && pattern.bytes[i3] != 125; ++i3) {
                if (pattern.bytes[i3] == 44) {
                    if (i3 <= pattern.begin || pattern.bytes[i3 - 1] != 92) break;
                    continue;
                }
                if (pattern.bytes[i3] != 123) continue;
                i3 = pattern.findClosingIndexOf(i3);
            }
            bytes2.length(0);
            bytes2.append(pattern.bytes, pattern.begin, lbrace - pattern.begin);
            bytes2.append(pattern.bytes, middleRegionIndex, i3 - middleRegionIndex);
            bytes2.append(pattern.bytes, rbrace + 1, pattern.end - (rbrace + 1));
            int status2 = Dir.push_braces(runtime2, cwd, result2, new GlobPattern(bytes2, pattern.flags), sort2);
            if (status2 == 0) continue;
            return status2;
        }
        return 0;
    }

    private static int push_globs(Ruby runtime2, String cwd, List<ByteList> ary, ByteList pattern, int flags2, boolean sort2) {
        ArrayList<ByteList> tmpAry = new ArrayList<ByteList>();
        int globRet = Dir.glob_helper(runtime2, cwd, pattern, -1, flags2 |= FNM_SYSCASE, glob_caller, new GlobArgs(push_pattern, tmpAry));
        if (sort2) {
            Collections.sort(tmpAry);
        }
        ary.addAll(tmpAry);
        return globRet;
    }

    public static ArrayList<String> braces(String pattern, int flags2, ArrayList<String> patterns) {
        boolean escape = (flags2 & 1) == 0;
        int rbrace = -1;
        int lbrace = -1;
        int i2 = pattern.indexOf(123);
        if (i2 >= 0) {
            int nest = 0;
            while (i2 < pattern.length()) {
                char c = pattern.charAt(i2);
                if (c == '{') {
                    if (nest == 0) {
                        lbrace = i2;
                    }
                    ++nest;
                }
                if (c == '}') {
                    --nest;
                }
                if (nest == 0) {
                    rbrace = i2;
                    break;
                }
                if (c == '\\' && escape) {
                    ++i2;
                }
                ++i2;
            }
        }
        if (lbrace >= 0 && rbrace >= 0) {
            int pos2 = lbrace;
            String front = pattern.substring(0, lbrace);
            String back = pattern.substring(rbrace + 1, pattern.length());
            while (pos2 < rbrace) {
                int nest = 0;
                int last2 = ++pos2;
                while (pos2 < rbrace && (pattern.charAt(pos2) != ',' || nest != 0)) {
                    if (pattern.charAt(pos2) == '{') {
                        ++nest;
                    }
                    if (pattern.charAt(pos2) == '}') {
                        --nest;
                    }
                    if (pattern.charAt(pos2) == '\\' && escape && ++pos2 == rbrace) break;
                    ++pos2;
                }
                String brace_pattern = front + pattern.substring(last2, pos2) + back;
                patterns.add(brace_pattern);
                Dir.braces(brace_pattern, flags2, patterns);
            }
        }
        return patterns;
    }

    private static boolean has_magic(byte[] bytes2, int begin2, int end2, int flags2) {
        boolean escape = (flags2 & 1) == 0;
        boolean nocase = (flags2 & 8) != 0;
        int open2 = 0;
        block6: for (int i2 = begin2; i2 < end2; ++i2) {
            switch (bytes2[i2]) {
                case 42: 
                case 63: {
                    return true;
                }
                case 91: {
                    ++open2;
                    continue block6;
                }
                case 93: {
                    if (open2 <= 0) continue block6;
                    return true;
                }
                case 92: {
                    if (!escape) continue block6;
                    return true;
                }
                default: {
                    if (FNM_SYSCASE != 0 || !nocase || !Character.isLetter((char)(bytes2[i2] & 0xFF))) continue block6;
                    return true;
                }
            }
        }
        return false;
    }

    private static int remove_backslashes(byte[] bytes2, int index2, int end2) {
        int i2 = index2;
        while (index2 < end2 && (bytes2[index2] != 92 || ++index2 != end2)) {
            bytes2[i2] = bytes2[index2];
            ++index2;
            ++i2;
        }
        return i2;
    }

    private static int indexOf(byte[] bytes2, int begin2, int end2, byte ch) {
        for (int i2 = begin2; i2 < end2; ++i2) {
            if (bytes2[i2] != ch) continue;
            return i2;
        }
        return -1;
    }

    private static byte[] extract_path(byte[] bytes2, int begin2, int end2) {
        int len = end2 - begin2;
        if (!(len <= 1 || bytes2[end2 - 1] != 47 || DOSISH && len >= 2 && bytes2[end2 - 2] == 58)) {
            --len;
        }
        byte[] alloc2 = new byte[len];
        System.arraycopy(bytes2, begin2, alloc2, 0, len);
        return alloc2;
    }

    private static byte[] extract_elem(byte[] bytes2, int begin2, int end2) {
        int elementEnd = Dir.indexOf(bytes2, begin2, end2, (byte)47);
        if (elementEnd == -1) {
            elementEnd = end2;
        }
        return Dir.extract_path(bytes2, begin2, elementEnd);
    }

    private static boolean beginsWithDriveLetter(byte[] path2, int begin2, int end2) {
        return DOSISH && begin2 + 2 < end2 && path2[begin2 + 1] == 58 && Dir.isdirsep(path2[begin2 + 2]);
    }

    private static boolean isRoot(byte[] base) {
        int length2 = base.length;
        return length2 == 0 || length2 == 1 && Dir.isdirsep(base[0]) || length2 == 3 && Dir.beginsWithDriveLetter(base, 0, length2);
    }

    private static boolean isAbsolutePath(byte[] path2, int begin2, int length2) {
        return Dir.isdirsep(path2[begin2]) || Dir.beginsWithDriveLetter(path2, begin2, length2);
    }

    private static String[] files(FileResource directory) {
        String[] files = directory.list();
        return files == null ? StringSupport.EMPTY_STRING_ARRAY : files;
    }

    private static boolean isSpecialFile(String name2) {
        int length2 = name2.length();
        if (length2 < 1 || length2 > 3 || name2.charAt(0) != '.') {
            return false;
        }
        if (length2 == 1) {
            return true;
        }
        char c = name2.charAt(1);
        if (length2 == 2 && (c == '.' || c == '/')) {
            return true;
        }
        return c == '.' && name2.charAt(2) == '/';
    }

    private static int addToResultIfExists(Ruby runtime2, String cwd, byte[] bytes2, int begin2, int end2, Encoding enc, int flags2, GlobFunc<GlobArgs> func, GlobArgs arg2) {
        FileResource file2;
        String fileName = new String(bytes2, begin2, end2 - begin2, enc.getCharset());
        if (Platform.IS_WINDOWS && cwd == null && !fileName.isEmpty() && fileName.charAt(0) == '/') {
            cwd = System.getenv("SYSTEMDRIVE");
            if (cwd == null) {
                cwd = "C:";
            }
            cwd = cwd + "/";
        }
        if ((file2 = JRubyFile.createResource(runtime2, cwd, fileName)).exists()) {
            byte[] newBytes;
            if (file2.isFile() && cwd != null) {
                String path2;
                String string2 = path2 = file2.isSymLink() ? file2.absolutePath() : file2.canonicalPath();
                if (fileName.endsWith("/")) {
                    path2 = path2 + "/";
                }
                if (fileName.contains("./")) {
                    newBytes = ("./" + path2.substring(path2.length() - end2 + 2)).getBytes();
                } else {
                    int tempBegin = path2.length() - fileName.length();
                    newBytes = path2.substring(tempBegin).getBytes();
                }
                end2 = newBytes.length;
            } else {
                newBytes = bytes2;
            }
            return func.call(newBytes, begin2, end2 - begin2, enc, arg2);
        }
        return 0;
    }

    private static int glob_helper(Ruby runtime2, String cwd, ByteList path2, int sub3, int flags2, GlobFunc<GlobArgs> func, GlobArgs arg2) {
        int begin2 = path2.getBegin();
        int end2 = begin2 + path2.getRealSize();
        Encoding enc = path2.getEncoding();
        return Dir.glob_helper(runtime2, cwd, path2.getUnsafeBytes(), begin2, end2, enc, sub3, flags2, func, arg2);
    }

    private static int glob_helper(Ruby runtime2, String cwd, byte[] path2, int begin2, int end2, Encoding enc, int sub3, int flags2, GlobFunc<GlobArgs> func, GlobArgs arg2) {
        int ptr;
        int status2 = 0;
        int n = ptr = sub3 != -1 ? sub3 : begin2;
        if (!Dir.has_magic(path2, ptr, end2, flags2)) {
            if (DOSISH || (flags2 & 1) == 0) {
                if (sub3 != -1) {
                    end2 = Dir.remove_backslashes(path2, sub3, end2);
                } else {
                    int len = end2 - begin2;
                    byte[] newPath = new byte[len];
                    System.arraycopy(path2, begin2, newPath, 0, len);
                    begin2 = 0;
                    end2 = Dir.remove_backslashes(newPath, 0, len);
                    path2 = newPath;
                }
            }
            if (end2 > begin2) {
                status2 = Dir.isAbsolutePath(path2, begin2, end2) ? Dir.addToResultIfExists(runtime2, null, path2, begin2, end2, enc, flags2, func, arg2) : Dir.addToResultIfExists(runtime2, cwd, path2, begin2, end2, enc, flags2, func, arg2);
            }
            return status2;
        }
        ArrayList<DirGlobber> links = new ArrayList<DirGlobber>();
        ByteList buf = new ByteList(20);
        buf.setEncoding(enc);
        while (ptr != -1 && status2 == 0) {
            int SLASH_INDEX;
            block19: {
                FileResource resource;
                block21: {
                    boolean recursive;
                    byte[] magic;
                    byte[] base;
                    block20: {
                        int nextStartIndex;
                        byte[] byArray;
                        if (path2[ptr] == 47) {
                            ++ptr;
                        }
                        if (!Dir.has_magic(path2, ptr, (SLASH_INDEX = Dir.indexOf(path2, ptr, end2, (byte)47)) == -1 ? end2 : SLASH_INDEX, flags2)) break block19;
                        base = Dir.extract_path(path2, begin2, ptr);
                        if (begin2 == ptr) {
                            byte[] byArray2 = new byte[1];
                            byArray = byArray2;
                            byArray2[0] = 46;
                        } else {
                            byArray = base;
                        }
                        byte[] dir = byArray;
                        magic = Dir.extract_elem(path2, ptr, end2);
                        recursive = false;
                        resource = JRubyFile.createResource(runtime2, cwd, new String(dir, 0, dir.length, enc.getCharset()));
                        if (!resource.isDirectory()) break;
                        if (SLASH_INDEX == -1 || !Arrays.equals(magic, DOUBLE_STAR)) break block20;
                        int lengthOfBase = base.length;
                        recursive = true;
                        buf.length(0);
                        buf.append(base);
                        int indexOfSlash = SLASH_INDEX;
                        do {
                            nextStartIndex = indexOfSlash + 1;
                            indexOfSlash = Dir.indexOf(path2, nextStartIndex, end2, (byte)47);
                        } while (Arrays.equals(magic = Dir.extract_elem(path2, nextStartIndex, end2), DOUBLE_STAR) && indexOfSlash != -1);
                        int remainingPathStartIndex = Arrays.equals(magic, DOUBLE_STAR) ? nextStartIndex : nextStartIndex - 1;
                        remainingPathStartIndex = lengthOfBase > 0 ? remainingPathStartIndex : remainingPathStartIndex + 1;
                        buf.append(path2, remainingPathStartIndex, end2 - remainingPathStartIndex);
                        status2 = Dir.glob_helper(runtime2, cwd, buf, lengthOfBase, flags2, func, arg2);
                        if (status2 != 0) break block21;
                    }
                    boolean skipdot = (flags2 & 0x80) != 0;
                    flags2 |= 0x80;
                    String[] files = Dir.files(resource);
                    for (int i2 = 0; i2 < files.length; ++i2) {
                        int length2;
                        String file2 = files[i2];
                        byte[] fileBytes = Dir.getBytesInUTF8(file2);
                        if (file2.charAt(0) == '.' && ((length2 = file2.length()) != 1 ? length2 == 2 && file2.charAt(1) == '.' : recursive && (flags2 & 4) == 0 || skipdot)) continue;
                        if (recursive) {
                            if (Dir.fnmatch(STAR, 0, 1, fileBytes, 0, fileBytes.length, flags2) != 0) continue;
                            buf.length(0);
                            buf.append(base);
                            buf.append(Dir.isRoot(base) ? EMPTY : SLASH);
                            buf.append(Dir.getBytesInUTF8(file2));
                            resource = JRubyFile.createResource(runtime2, cwd, new String(buf.unsafeBytes(), buf.begin(), buf.length(), enc.getCharset()));
                            if (resource.isSymLink() || !resource.isDirectory() || ".".equals(file2) || "..".equals(file2)) continue;
                            int len = buf.getRealSize();
                            buf.append(SLASH);
                            buf.append(DOUBLE_STAR);
                            buf.append(path2, SLASH_INDEX, end2 - SLASH_INDEX);
                            status2 = Dir.glob_helper(runtime2, cwd, buf, buf.getBegin() + len, flags2, func, arg2);
                            if (status2 == 0) continue;
                            break;
                        }
                        if (Dir.fnmatch(magic, 0, magic.length, fileBytes, 0, fileBytes.length, flags2) != 0) continue;
                        buf.length(0);
                        buf.append(base);
                        buf.append(Dir.isRoot(base) ? EMPTY : SLASH);
                        buf.append(Dir.getBytesInUTF8(file2));
                        if (SLASH_INDEX == -1) {
                            status2 = func.call(buf.getUnsafeBytes(), 0, buf.getRealSize(), enc, arg2);
                            if (status2 == 0) continue;
                            break;
                        }
                        links.add(new DirGlobber(buf));
                        buf = new ByteList(20);
                        buf.setEncoding(enc);
                    }
                }
                if (links.size() > 0) {
                    for (DirGlobber globber : links) {
                        ByteList link2 = globber.link;
                        if (status2 != 0 || !(resource = JRubyFile.createResource(runtime2, cwd, RubyString.byteListToString(link2))).isDirectory()) continue;
                        int len = link2.getRealSize();
                        buf.length(0);
                        buf.append(link2);
                        buf.append(path2, SLASH_INDEX, end2 - SLASH_INDEX);
                        status2 = Dir.glob_helper(runtime2, cwd, buf, buf.getBegin() + len, flags2, func, arg2);
                    }
                    break;
                }
            }
            ptr = SLASH_INDEX;
        }
        return status2;
    }

    private static byte[] getBytesInUTF8(String str) {
        return RubyEncoding.encodeUTF8(str);
    }

    @Deprecated
    public static int range(byte[] _pat, int pat, int pend, char test2, int flags2) {
        return new FilenameMatch(pat, 0, flags2).helper(_pat, pend, new byte[]{(byte)test2}, 1, ASCIIEncoding.INSTANCE);
    }

    private static final class DirGlobber {
        public final ByteList link;

        DirGlobber(ByteList link2) {
            this.link = link2;
        }
    }

    private static class GlobArgs {
        final GlobFunc<List<ByteList>> func;
        final List<ByteList> arg;
        private int c = -1;

        GlobArgs(GlobFunc<List<ByteList>> func, List<ByteList> arg2) {
            this.func = func;
            this.arg = arg2;
        }
    }

    private static interface GlobFunc<T> {
        public int call(byte[] var1, int var2, int var3, Encoding var4, T var5);
    }

    private static class GlobPattern {
        final byte[] bytes;
        final int begin;
        final int end;
        final Encoding enc;
        private int index;
        private final int flags;

        GlobPattern(ByteList bytes2, int flags2) {
            this(bytes2.getUnsafeBytes(), bytes2.getBegin(), bytes2.getBegin() + bytes2.getRealSize(), bytes2.getEncoding(), flags2);
        }

        GlobPattern(byte[] bytes2, int index2, int end2, Encoding enc, int flags2) {
            this.bytes = bytes2;
            this.index = index2;
            this.begin = index2;
            this.end = end2;
            this.enc = enc;
            this.flags = flags2;
        }

        public int findClosingIndexOf(int leftTokenIndex) {
            byte rightToken;
            if (leftTokenIndex == -1 || leftTokenIndex > this.end) {
                return -1;
            }
            byte leftToken = this.bytes[leftTokenIndex];
            switch (leftToken) {
                case 123: {
                    rightToken = 125;
                    break;
                }
                case 91: {
                    rightToken = 93;
                    break;
                }
                default: {
                    return -1;
                }
            }
            int nest = 1;
            this.index = leftTokenIndex + 1;
            while (this.hasNext()) {
                byte c = this.next();
                if (c == leftToken) {
                    ++nest;
                    continue;
                }
                if (c != rightToken || --nest != 0) continue;
                return this.index();
            }
            return -1;
        }

        public boolean hasNext() {
            return this.index < this.end;
        }

        public void reset() {
            this.index = this.begin;
        }

        public void setIndex(int value2) {
            this.index = value2;
        }

        public int index() {
            return this.index - 1;
        }

        public int indexOf(byte c) {
            while (this.hasNext()) {
                if (this.next() != c) continue;
                return this.index();
            }
            return -1;
        }

        public byte next() {
            return this.bytes[this.index++];
        }
    }

    static class FilenameMatch {
        int pcur;
        int scur;
        final int flags;
        final boolean escape;
        final boolean pathname;
        final boolean period;
        final boolean nocase;

        FilenameMatch(int pcur, int scur, int flags2) {
            this.pcur = pcur;
            this.scur = scur;
            this.flags = flags2;
            this.escape = (flags2 & 1) == 0;
            this.pathname = (flags2 & 2) != 0;
            this.period = (flags2 & 4) == 0;
            this.nocase = (flags2 & 8) != 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int helper(byte[] pbytes, int pend, byte[] sbytes, int send2, Encoding enc) {
            int s2 = this.scur;
            int p2 = this.pcur;
            int ptmp = -1;
            int stmp = -1;
            if (s2 < send2 && p2 < pend && this.period && sbytes[s2] == 46 && pbytes[this.unescape(pbytes, p2)] != 46) {
                return 1;
            }
            try {
                int n;
                block15: while (true) {
                    if (p2 >= pend) {
                        if (this.isEnd(sbytes, s2, send2)) {
                            n = 0;
                            return n;
                        }
                        if (ptmp != -1 && stmp != -1) {
                            p2 = ptmp;
                            s2 = ++stmp;
                            continue;
                        }
                        n = 1;
                        return n;
                    }
                    switch (pbytes[p2]) {
                        case 42: {
                            while (++p2 < pend && pbytes[p2] == 42) {
                            }
                            if (this.isEnd(pbytes, this.unescape(pbytes, p2), pend)) {
                                n = 0;
                                return n;
                            }
                            if (this.isEnd(sbytes, s2, send2)) {
                                n = 1;
                                return n;
                            }
                            ptmp = p2;
                            stmp = s2;
                            continue block15;
                        }
                        case 63: {
                            if (this.isEnd(sbytes, s2, send2)) {
                                n = 1;
                                return n;
                            }
                            ++p2;
                            s2 += StringSupport.length(enc, sbytes, s2, send2);
                            continue block15;
                        }
                        case 91: {
                            if (this.isEnd(sbytes, s2, send2)) {
                                n = 1;
                                return n;
                            }
                            int t = this.bracket(pbytes, p2 + 1, pend, sbytes, s2, send2, enc);
                            if (t == -1) break;
                            p2 = t;
                            s2 += StringSupport.length(enc, sbytes, s2, send2);
                            continue block15;
                        }
                        default: {
                            int r;
                            p2 = this.unescape(pbytes, p2);
                            if (this.isEnd(sbytes, s2, send2)) {
                                int n2 = this.isEnd(pbytes, p2, pend) ? 0 : 1;
                                return n2;
                            }
                            if (this.isEnd(pbytes, p2, pend) || !StringSupport.MBCLEN_CHARFOUND_P(r = StringSupport.preciseLength(enc, pbytes, p2, pend))) break;
                            if (r <= send2 - s2 && ByteList.memcmp(pbytes, p2, r, sbytes, s2, r) == 0) {
                                p2 += r;
                                s2 += r;
                                continue block15;
                            }
                            if (!(DOSISH && this.pathname && Dir.isdirsep(pbytes[p2]) && Dir.isdirsep(sbytes[s2]) || this.nocase && Character.toLowerCase(StringSupport.codePoint(enc, pbytes, p2, pend)) == Character.toLowerCase(StringSupport.codePoint(enc, sbytes, s2, send2)))) break;
                            p2 += r;
                            s2 += StringSupport.length(enc, sbytes, s2, send2);
                            continue block15;
                        }
                    }
                    if (ptmp == -1 || stmp == -1) break;
                    p2 = ptmp;
                    s2 = ++stmp;
                }
                n = 1;
                return n;
            }
            finally {
                this.pcur = p2;
                this.scur = s2;
            }
        }

        public int bracket(byte[] pbytes, int p2, int pend, byte[] sbytes, int s2, int send2, Encoding enc) {
            boolean not = false;
            boolean ok = false;
            if (p2 >= pend) {
                return -1;
            }
            if (pbytes[p2] == 33 || pbytes[p2] == 94) {
                not = true;
                ++p2;
            }
            while (true) {
                int c2;
                int c1;
                if (p2 >= pend) {
                    return -1;
                }
                if (pbytes[p2] == 93) break;
                int t1 = p2;
                if (this.escape && pbytes[t1] == 92) {
                    ++t1;
                }
                if (t1 >= pend) {
                    return -1;
                }
                int r = StringSupport.length(enc, pbytes, t1, pend);
                p2 = t1 + r;
                if (p2 >= pend) {
                    return -1;
                }
                if (pbytes[p2] == 45 && pbytes[p2 + 1] != 93) {
                    int t2 = p2 + 1;
                    if (this.escape && pbytes[t2] == 92) {
                        ++t2;
                    }
                    if (t2 >= pend) {
                        return -1;
                    }
                    int r2 = StringSupport.length(enc, pbytes, t2, pend);
                    p2 = t2 + r2;
                    if (ok) continue;
                    if (r <= send2 - s2 && ByteList.memcmp(pbytes, t1, r, sbytes, s2, r) == 0 || r2 <= send2 - s2 && ByteList.memcmp(pbytes, t2, r2, sbytes, s2, r2) == 0) {
                        ok = true;
                        continue;
                    }
                    c1 = StringSupport.codePoint(enc, sbytes, s2, send2);
                    if (this.nocase) {
                        c1 = Character.toUpperCase(c1);
                    }
                    c2 = StringSupport.codePoint(enc, pbytes, t1, pend);
                    if (this.nocase) {
                        c2 = Character.toUpperCase(c2);
                    }
                    if (c1 < c2) continue;
                    c2 = StringSupport.codePoint(enc, pbytes, t2, pend);
                    if (this.nocase) {
                        c2 = Character.toUpperCase(c2);
                    }
                    if (c1 > c2) {
                        continue;
                    }
                } else {
                    if (ok) continue;
                    if (r <= send2 - s2 && ByteList.memcmp(pbytes, t1, r, sbytes, s2, r) == 0) {
                        ok = true;
                        continue;
                    }
                    if (!this.nocase || (c1 = Character.toUpperCase(StringSupport.codePoint(enc, sbytes, s2, send2))) != (c2 = Character.toUpperCase(StringSupport.codePoint(enc, pbytes, p2, pend)))) continue;
                }
                ok = true;
            }
            return ok == not ? -1 : p2 + 1;
        }

        private int unescape(byte[] bytes2, int i2) {
            if (this.escape && i2 < bytes2.length && bytes2[i2] == 92) {
                return i2 + 1;
            }
            return i2;
        }

        private boolean isEnd(byte[] sbytes, int s2, int send2) {
            return s2 >= send2 || this.pathname && Dir.isdirsep(sbytes[s2]);
        }
    }
}

