/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.saml;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class SamlSpMetadataRequest
extends ActionRequest {
    private String realmName;

    public SamlSpMetadataRequest(StreamInput in) throws IOException {
        super(in);
        this.realmName = in.readOptionalString();
    }

    public SamlSpMetadataRequest(String realmName) {
        this.realmName = realmName;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (!Strings.hasText(this.realmName)) {
            validationException = ValidateActions.addValidationError("Realm name may not be empty", validationException);
        }
        return validationException;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{realmName=" + this.realmName + "}";
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.realmName);
    }
}

