/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.apikey;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.security.action.apikey.ApiKey;

public final class GetApiKeyResponse
extends ActionResponse
implements ToXContentObject {
    public static final GetApiKeyResponse EMPTY = new GetApiKeyResponse(List.of());
    private final List<Item> foundApiKeyInfoList;
    static final ConstructingObjectParser<GetApiKeyResponse, Void> RESPONSE_PARSER;

    public GetApiKeyResponse(Collection<Item> foundApiKeysInfos) {
        Objects.requireNonNull(foundApiKeysInfos, "found_api_keys_info must be provided");
        this.foundApiKeyInfoList = foundApiKeysInfos instanceof List ? (List<Object>)foundApiKeysInfos : new ArrayList<Item>(foundApiKeysInfos);
    }

    public GetApiKeyResponse(Collection<ApiKey> foundApiKeysInfos, @Nullable Collection<String> ownerProfileUids) {
        Objects.requireNonNull(foundApiKeysInfos, "found_api_keys_info must be provided");
        if (ownerProfileUids == null) {
            this.foundApiKeyInfoList = foundApiKeysInfos.stream().map(Item::new).toList();
        } else {
            if (foundApiKeysInfos.size() != ownerProfileUids.size()) {
                throw new IllegalStateException("Each api key info must be associated to a (nullable) owner profile uid");
            }
            int size = foundApiKeysInfos.size();
            this.foundApiKeyInfoList = new ArrayList<Item>(size);
            Iterator<ApiKey> apiKeyIterator = foundApiKeysInfos.iterator();
            Iterator<String> profileUidIterator = ownerProfileUids.iterator();
            while (apiKeyIterator.hasNext()) {
                if (!profileUidIterator.hasNext()) {
                    throw new IllegalStateException("Each api key info must be associated to a (nullable) owner profile uid");
                }
                this.foundApiKeyInfoList.add(new Item(apiKeyIterator.next(), profileUidIterator.next()));
            }
        }
    }

    public List<Item> getApiKeyInfoList() {
        return this.foundApiKeyInfoList;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("api_keys", (Iterable<?>)this.foundApiKeyInfoList);
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        TransportAction.localOnly();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetApiKeyResponse that = (GetApiKeyResponse)o;
        return Objects.equals(this.foundApiKeyInfoList, that.foundApiKeyInfoList);
    }

    public int hashCode() {
        return Objects.hash(this.foundApiKeyInfoList);
    }

    public String toString() {
        return "GetApiKeyResponse{foundApiKeysInfo=" + String.valueOf(this.foundApiKeyInfoList) + "}";
    }

    public static GetApiKeyResponse fromXContent(XContentParser parser) throws IOException {
        return RESPONSE_PARSER.parse(parser, null);
    }

    static {
        int nFieldsForParsingApiKeyInfo = 13;
        ConstructingObjectParser keyInfoParser = new ConstructingObjectParser("api_key_with_profile_uid", true, args -> new Item(new ApiKey((Object[])args), (String)args[nFieldsForParsingApiKeyInfo]));
        int nParsedFields = ApiKey.initializeParser(keyInfoParser);
        if (nFieldsForParsingApiKeyInfo != nParsedFields) {
            throw new IllegalStateException("Unexpected fields for parsing API Keys");
        }
        keyInfoParser.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), new ParseField("profile_uid", new String[0]));
        RESPONSE_PARSER = new ConstructingObjectParser("get_api_key_response", args -> {
            if (args[0] == null) {
                return EMPTY;
            }
            List apiKeysWithProfileUids = (List)args[0];
            return new GetApiKeyResponse(apiKeysWithProfileUids);
        });
        RESPONSE_PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), keyInfoParser, new ParseField("api_keys", new String[0]));
    }

    public record Item(ApiKey apiKeyInfo, @Nullable String ownerProfileUid) implements ToXContentObject
    {
        public Item(ApiKey apiKeyInfo) {
            this(apiKeyInfo, null);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.apiKeyInfo.innerToXContent(builder, params);
            if (this.ownerProfileUid != null) {
                builder.field("profile_uid", this.ownerProfileUid);
            }
            builder.endObject();
            return builder;
        }

        @Override
        public String toString() {
            return "Item{apiKeyInfo=" + String.valueOf(this.apiKeyInfo) + ", ownerProfileUid=" + this.ownerProfileUid + "}";
        }
    }
}

