/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public record MlConfigVersion(int id) implements VersionId<MlConfigVersion>,
ToXContentFragment
{
    private static Map<String, Integer> IDS = new HashMap<String, Integer>();
    public static final String ML_CONFIG_VERSION_NODE_ATTR = "ml.config_version";
    public static final MlConfigVersion ZERO = MlConfigVersion.registerMlConfigVersion(0, "00000000-0000-0000-0000-000000000000");
    public static final MlConfigVersion V_5_4_0 = MlConfigVersion.registerMlConfigVersion(5040099, "B917B447-2CC6-4BD8-BEB2-733D157B7B37");
    public static final MlConfigVersion V_6_0_0 = MlConfigVersion.registerMlConfigVersion(6000099, "E3F1CC55-A992-4CB3-BCE6-EC310D156793");
    public static final MlConfigVersion V_7_0_0 = MlConfigVersion.registerMlConfigVersion(7000099, "21906C88-0955-4BE3-B4B3-BFB6B9606112");
    public static final MlConfigVersion V_7_0_1 = MlConfigVersion.registerMlConfigVersion(7000199, "7FF09B06-20B3-40FF-A6E0-EC94F55B8B56");
    public static final MlConfigVersion V_7_1_0 = MlConfigVersion.registerMlConfigVersion(7010099, "BD49F37F-1E50-4BC1-B227-EE0AC88B677C");
    public static final MlConfigVersion V_7_2_0 = MlConfigVersion.registerMlConfigVersion(7020099, "4DCD30C3-FF6B-4195-AD28-4600D48F4A7B");
    public static final MlConfigVersion V_7_2_1 = MlConfigVersion.registerMlConfigVersion(7020199, "0C6EDC80-77C9-4897-843B-EC4377E997FD");
    public static final MlConfigVersion V_7_3_0 = MlConfigVersion.registerMlConfigVersion(7030099, "69107EE3-48A7-4FC2-BDB3-7440C4B3E0D4");
    public static final MlConfigVersion V_7_3_2 = MlConfigVersion.registerMlConfigVersion(7030299, "2155846F-36F5-420B-BD29-6415019AB64A");
    public static final MlConfigVersion V_7_4_0 = MlConfigVersion.registerMlConfigVersion(7040099, "21E66DF1-9AAE-40E8-9EF0-E4494CF513B6");
    public static final MlConfigVersion V_7_5_0 = MlConfigVersion.registerMlConfigVersion(7050099, "ED5D4FA8-E22B-4ABD-A69E-76BBE9363CDD");
    public static final MlConfigVersion V_7_6_0 = MlConfigVersion.registerMlConfigVersion(7060099, "1155C404-6ABA-4782-9A6D-FD7167D4109C");
    public static final MlConfigVersion V_7_7_0 = MlConfigVersion.registerMlConfigVersion(7070099, "5369472F-3845-4759-9927-875DCACB66FC");
    public static final MlConfigVersion V_7_8_0 = MlConfigVersion.registerMlConfigVersion(7080099, "94F8181D-4F74-4C22-9015-7BE6D2ACA9FE");
    public static final MlConfigVersion V_7_8_1 = MlConfigVersion.registerMlConfigVersion(7080199, "1522F9FD-CAD5-4221-95A8-61C22C9AA4FD");
    public static final MlConfigVersion V_7_9_0 = MlConfigVersion.registerMlConfigVersion(7090099, "42557660-0127-47B3-B01F-B02E2A5B47DB");
    public static final MlConfigVersion V_7_9_1 = MlConfigVersion.registerMlConfigVersion(7090199, "0AA38DE2-74C0-4D36-BCA9-AAB2EE728D2C");
    public static final MlConfigVersion V_7_9_2 = MlConfigVersion.registerMlConfigVersion(7090299, "165B1C7D-51A7-4FC6-A673-28885C2403E0");
    public static final MlConfigVersion V_7_9_3 = MlConfigVersion.registerMlConfigVersion(7090399, "4B9B8DB4-D1C1-4F8B-994A-3352CE4C376E");
    public static final MlConfigVersion V_7_10_0 = MlConfigVersion.registerMlConfigVersion(7100099, "389FEA3F-1A53-4F26-AEBA-584EF954596F");
    public static final MlConfigVersion V_7_10_1 = MlConfigVersion.registerMlConfigVersion(7100199, "ACA28B55-87B8-4F87-9517-7B3345F1F789");
    public static final MlConfigVersion V_7_11_0 = MlConfigVersion.registerMlConfigVersion(7110099, "0377318D-6D53-41C5-A376-8E42E1435806");
    public static final MlConfigVersion V_7_12_0 = MlConfigVersion.registerMlConfigVersion(7120099, "0CB23517-70F2-4F26-9E7D-8F6FCD16B14A");
    public static final MlConfigVersion V_7_13_0 = MlConfigVersion.registerMlConfigVersion(7130099, "49BE3B14-9E33-48A2-B605-DB0B61AAD49D");
    public static final MlConfigVersion V_7_14_0 = MlConfigVersion.registerMlConfigVersion(7140099, "DD87203A-2CBD-40A6-A466-70D9F560B282");
    public static final MlConfigVersion V_7_15_0 = MlConfigVersion.registerMlConfigVersion(7150099, "890AA965-41D4-4C99-9493-2CA8BBD06C99");
    public static final MlConfigVersion V_7_15_1 = MlConfigVersion.registerMlConfigVersion(7150199, "0C0EC66A-DAD7-4448-99F6-A13D465D5203");
    public static final MlConfigVersion V_7_16_0 = MlConfigVersion.registerMlConfigVersion(7160099, "F4C8C99C-EC0D-4119-AD6A-CFEEAFE6461C");
    public static final MlConfigVersion V_7_17_0 = MlConfigVersion.registerMlConfigVersion(7170099, "056316CB-61CB-4A5D-84BB-8ACDA24D5748");
    public static final MlConfigVersion V_7_17_1 = MlConfigVersion.registerMlConfigVersion(7170199, "A0006AC5-7C5A-42CC-97F7-8792FC8DEEAC");
    public static final MlConfigVersion V_7_17_8 = MlConfigVersion.registerMlConfigVersion(7170899, "A769CAD5-0A3F-4CB4-BC0C-9CFDCC6D6605");
    public static final MlConfigVersion V_8_0_0 = MlConfigVersion.registerMlConfigVersion(8000099, "2B5AFCFD-90F9-41CD-9E55-4D2711F03758");
    public static final MlConfigVersion V_8_1_0 = MlConfigVersion.registerMlConfigVersion(8010099, "4E1B967E-4BFA-4C41-8F59-E43C87B1DEFF");
    public static final MlConfigVersion V_8_2_0 = MlConfigVersion.registerMlConfigVersion(8020099, "01E035F3-D864-4094-8523-84D717EFB89D");
    public static final MlConfigVersion V_8_3_0 = MlConfigVersion.registerMlConfigVersion(8030099, "574B950D-2E9F-4CCA-9E61-F93B4420D800");
    public static final MlConfigVersion V_8_4_0 = MlConfigVersion.registerMlConfigVersion(8040099, "D92DAC63-DAE6-4858-9E63-9BD91B67459A");
    public static final MlConfigVersion V_8_5_0 = MlConfigVersion.registerMlConfigVersion(8050099, "178A2E20-8F8E-4430-A002-B156E1E99B22");
    public static final MlConfigVersion V_8_6_0 = MlConfigVersion.registerMlConfigVersion(8060099, "C910CB2A-A7B5-47AE-A9F5-FAC8F5205D27");
    public static final MlConfigVersion V_8_6_1 = MlConfigVersion.registerMlConfigVersion(8060199, "DFD4116C-1173-4461-8A00-00E0ADCAD2C2");
    public static final MlConfigVersion V_8_7_0 = MlConfigVersion.registerMlConfigVersion(8070099, "C9A8AACB-84FA-44C6-A541-2FDEAECB280D");
    public static final MlConfigVersion V_8_7_1 = MlConfigVersion.registerMlConfigVersion(8070199, "B2EC2F2F-9D73-4057-A21C-23E0EF3AD311");
    public static final MlConfigVersion V_8_8_0 = MlConfigVersion.registerMlConfigVersion(8080099, "8E50EED5-54E3-45B1-A3B2-83A44ADBBF09");
    public static final MlConfigVersion V_8_8_1 = MlConfigVersion.registerMlConfigVersion(0x7B4B47, "99A928F3-FD13-4325-9770-317EB624C85C");
    public static final MlConfigVersion V_8_9_0 = MlConfigVersion.registerMlConfigVersion(8090099, "C50F56AB-4DB8-48A5-9467-4F5B07365C5C");
    private static final MlConfigVersion V_8_10_0 = MlConfigVersion.registerMlConfigVersion(8100099, "9315A548-D81B-4FE7-8C0D-0DA81EA00F9E");
    public static final MlConfigVersion V_10 = MlConfigVersion.registerMlConfigVersion(10000099, "4B940FD9-BEDD-4589-8E08-02D9B480B22D");
    public static final MlConfigVersion V_11 = MlConfigVersion.registerMlConfigVersion(11000099, "79CB2950-57C7-11EE-AE5D-0800200C9A66");
    public static final MlConfigVersion V_12;
    public static final MlConfigVersion CURRENT;
    public static final MlConfigVersion MINIMUM_DETACHED_ML_CONFIG_VERSION;
    public static final MlConfigVersion FIRST_ML_VERSION;
    private static final NavigableMap<Integer, MlConfigVersion> VERSION_IDS;

    private static MlConfigVersion registerMlConfigVersion(int id, String uniqueId) {
        MlConfigVersion.checkUniqueness(id, uniqueId);
        return new MlConfigVersion(id);
    }

    private static void checkUniqueness(int id, String uniqueId) {
        if (IDS == null) {
            throw new IllegalStateException("The IDS map needs to be present to call this method");
        }
        Strings.requireNonEmpty(uniqueId, "Each MlConfigVersion needs a unique string id");
        Integer existing = IDS.put(uniqueId, id);
        if (existing != null) {
            throw new IllegalArgumentException("Versions " + id + " and " + existing + " have the same unique id");
        }
    }

    public static NavigableMap<Integer, MlConfigVersion> getAllVersionIds(Class<?> cls) {
        HashMap<Integer, String> versionIdFields = new HashMap<Integer, String>();
        TreeMap<Integer, MlConfigVersion> builder = new TreeMap<Integer, MlConfigVersion>();
        Set<String> ignore = Set.of("V_8_10_0", "ZERO", "CURRENT", "FIRST_ML_VERSION");
        for (Field declaredField : cls.getFields()) {
            MlConfigVersion version;
            String fieldName;
            if (!declaredField.getType().equals(MlConfigVersion.class) || ignore.contains(fieldName = declaredField.getName()) || !fieldName.matches("V_.*")) continue;
            try {
                version = (MlConfigVersion)declaredField.get(null);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            builder.put(version.id, version);
            if (!Assertions.ENABLED) continue;
            String sameVersionNumber = versionIdFields.put(version.id, fieldName);
            assert (sameVersionNumber == null) : "Versions [" + sameVersionNumber + "] and [" + fieldName + "] have the same version number [" + version.id + "]. Each MlConfigVersion should have a different version number";
        }
        return Collections.unmodifiableNavigableMap(builder);
    }

    static Collection<MlConfigVersion> getAllVersions() {
        return VERSION_IDS.values();
    }

    public static MlConfigVersion readVersion(StreamInput in) throws IOException {
        return MlConfigVersion.fromId(in.readVInt());
    }

    public static MlConfigVersion fromId(int id) {
        MlConfigVersion known = (MlConfigVersion)VERSION_IDS.get(id);
        if (known != null) {
            return known;
        }
        return new MlConfigVersion(id);
    }

    public static MlConfigVersion fromNode(DiscoveryNode node) {
        return MlConfigVersion.getMlConfigVersionForNode(node);
    }

    public static void writeVersion(MlConfigVersion version, StreamOutput out) throws IOException {
        out.writeVInt(version.id);
    }

    public static MlConfigVersion min(MlConfigVersion version1, MlConfigVersion version2) {
        return version1.id < version2.id ? version1 : version2;
    }

    public static MlConfigVersion max(MlConfigVersion version1, MlConfigVersion version2) {
        return version1.id > version2.id ? version1 : version2;
    }

    public static MlConfigVersion getMinMlConfigVersion(DiscoveryNodes nodes) {
        return MlConfigVersion.getMinMaxMlConfigVersion(nodes).v1();
    }

    public static MlConfigVersion getMaxMlConfigVersion(DiscoveryNodes nodes) {
        return MlConfigVersion.getMinMaxMlConfigVersion(nodes).v2();
    }

    public static Tuple<MlConfigVersion, MlConfigVersion> getMinMaxMlConfigVersion(DiscoveryNodes nodes) {
        MlConfigVersion minMlConfigVersion = CURRENT;
        MlConfigVersion maxMlConfigVersion = FIRST_ML_VERSION;
        for (DiscoveryNode node : nodes) {
            try {
                MlConfigVersion mlConfigVersion = MlConfigVersion.getMlConfigVersionForNode(node);
                if (mlConfigVersion.before(minMlConfigVersion)) {
                    minMlConfigVersion = mlConfigVersion;
                }
                if (!mlConfigVersion.after(maxMlConfigVersion)) continue;
                maxMlConfigVersion = mlConfigVersion;
            }
            catch (IllegalStateException illegalStateException) {}
        }
        return new Tuple<MlConfigVersion, MlConfigVersion>(minMlConfigVersion, maxMlConfigVersion);
    }

    public static MlConfigVersion getMlConfigVersionForNode(DiscoveryNode node) {
        String mlConfigVerStr = node.getAttributes().get(ML_CONFIG_VERSION_NODE_ATTR);
        if (mlConfigVerStr == null) {
            throw new IllegalStateException("ml.config_version not present on node");
        }
        return MlConfigVersion.fromString(mlConfigVerStr);
    }

    public static MlConfigVersion fromString(String str) {
        if (str == null) {
            return CURRENT;
        }
        if (str.startsWith("8.10.") || str.equals("8.11.0")) {
            return V_10;
        }
        Matcher matcher = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)(?:-\\w+)?$").matcher(str);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("ML config version [" + str + "] not valid");
        }
        int first = Integer.parseInt(matcher.group(1));
        int second = Integer.parseInt(matcher.group(2));
        int third = Integer.parseInt(matcher.group(3));
        if (first >= 10 && (second > 0 || third > 0)) {
            throw new IllegalArgumentException("ML config version [" + str + "] not valid");
        }
        return MlConfigVersion.fromId(1000000 * first + 10000 * second + 100 * third + 99);
    }

    @Override
    public String toString() {
        int major = this.id / 1000000;
        if (this.id < MINIMUM_DETACHED_ML_CONFIG_VERSION.id()) {
            int minor = this.id % 1000000 / 10000;
            int patch = this.id % 1000000 % 10000 / 100;
            return major + "." + minor + "." + patch;
        }
        return major + ".0.0";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.value(this.toString());
    }

    static {
        CURRENT = V_12 = MlConfigVersion.registerMlConfigVersion(12000099, "Trained model config prefix strings added");
        MINIMUM_DETACHED_ML_CONFIG_VERSION = V_10;
        FIRST_ML_VERSION = V_5_4_0;
        IDS = null;
        VERSION_IDS = MlConfigVersion.getAllVersionIds(MlConfigVersion.class);
    }
}

