/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.info.ClusterInfoRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;

public class ExplainLifecycleRequest
extends ClusterInfoRequest<ExplainLifecycleRequest> {
    private boolean onlyErrors = false;
    private boolean onlyManaged = false;

    public ExplainLifecycleRequest(TimeValue masterTimeout) {
        super(masterTimeout, IndicesOptions.strictExpandOpen());
    }

    public ExplainLifecycleRequest(StreamInput in) throws IOException {
        super(in);
        this.onlyErrors = in.readBoolean();
        this.onlyManaged = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.onlyErrors);
        out.writeBoolean(this.onlyManaged);
    }

    public boolean onlyErrors() {
        return this.onlyErrors;
    }

    public ExplainLifecycleRequest onlyErrors(boolean onlyErrors) {
        this.onlyErrors = onlyErrors;
        return this;
    }

    public boolean onlyManaged() {
        return this.onlyManaged;
    }

    public ExplainLifecycleRequest onlyManaged(boolean onlyManaged) {
        this.onlyManaged = onlyManaged;
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.indices()), this.indicesOptions(), this.onlyErrors, this.onlyManaged);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ExplainLifecycleRequest other = (ExplainLifecycleRequest)obj;
        return Objects.deepEquals(this.indices(), other.indices()) && Objects.equals(this.indicesOptions(), other.indicesOptions()) && Objects.equals(this.onlyErrors(), other.onlyErrors()) && Objects.equals(this.onlyManaged(), other.onlyManaged());
    }

    @Override
    public String toString() {
        return "ExplainLifecycleRequest [indices()=" + Arrays.toString(this.indices()) + ", indicesOptions()=" + String.valueOf(this.indicesOptions()) + ", onlyErrors()=" + this.onlyErrors() + ", onlyManaged()=" + this.onlyManaged() + "]";
    }
}

