/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.close.CloseIndexRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.ilm.AsyncRetryDuringSnapshotActionStep;
import org.elasticsearch.xpack.core.ilm.Step;

final class CloseFollowerIndexStep
extends AsyncRetryDuringSnapshotActionStep {
    static final String NAME = "close-follower-index";

    CloseFollowerIndexStep(Step.StepKey key, Step.StepKey nextStepKey, Client client) {
        super(key, nextStepKey, client);
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    void performDuringNoSnapshot(IndexMetadata indexMetadata, ClusterState currentClusterState, ActionListener<Void> listener) {
        String followerIndex = indexMetadata.getIndex().getName();
        Map<String, String> customIndexMetadata = indexMetadata.getCustomData("ccr");
        if (customIndexMetadata == null) {
            listener.onResponse(null);
            return;
        }
        if (indexMetadata.getState() == IndexMetadata.State.OPEN) {
            CloseIndexRequest closeIndexRequest = (CloseIndexRequest)new CloseIndexRequest(followerIndex).masterNodeTimeout(TimeValue.MAX_VALUE);
            this.getClient().admin().indices().close(closeIndexRequest, listener.delegateFailureAndWrap((l, r) -> {
                if (!r.isAcknowledged()) {
                    throw new ElasticsearchException("close index request failed to be acknowledged", new Object[0]);
                }
                l.onResponse(null);
            }));
        } else {
            listener.onResponse(null);
        }
    }
}

