/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.lang.ref.Cleaner;
import java.util.HashSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.Releasable;

public final class LeakTracker {
    private static final Logger logger = LogManager.getLogger(LeakTracker.class);
    private static final Cleaner cleaner = Cleaner.create();
    private static final int TARGET_RECORDS = 25;
    private final ConcurrentMap<String, Boolean> reportedLeaks = ConcurrentCollections.newConcurrentMap();
    public static final LeakTracker INSTANCE = new LeakTracker();
    private static volatile String contextHint = "";

    private LeakTracker() {
    }

    public Leak track(Object obj) {
        return new Leak(obj);
    }

    public static void setContextHint(String hint) {
        contextHint = hint;
    }

    public static Releasable wrap(final Releasable releasable) {
        if (!Assertions.ENABLED) {
            return releasable;
        }
        final Leak leak = INSTANCE.track(releasable);
        return new Releasable(){

            @Override
            public void close() {
                try {
                    releasable.close();
                }
                finally {
                    leak.close();
                }
            }

            public int hashCode() {
                throw new AssertionError((Object)"almost certainly a mistake to need the hashCode() of a leak-tracking Releasable");
            }

            public boolean equals(Object obj) {
                throw new AssertionError((Object)"almost certainly a mistake to compare a leak-tracking Releasable for equality");
            }
        };
    }

    public static RefCounted wrap(final RefCounted refCounted) {
        if (!Assertions.ENABLED) {
            return refCounted;
        }
        final Leak leak = INSTANCE.track(refCounted);
        return new RefCounted(){

            @Override
            public void incRef() {
                leak.record();
                refCounted.incRef();
            }

            @Override
            public boolean tryIncRef() {
                leak.record();
                return refCounted.tryIncRef();
            }

            @Override
            public boolean decRef() {
                if (refCounted.decRef()) {
                    leak.close();
                    return true;
                }
                leak.record();
                return false;
            }

            @Override
            public boolean hasReferences() {
                return refCounted.hasReferences();
            }

            public int hashCode() {
                throw new AssertionError((Object)"almost certainly a mistake to need the hashCode() of a leak-tracking RefCounted");
            }

            public boolean equals(Object obj) {
                throw new AssertionError((Object)"almost certainly a mistake to compare a leak-tracking RefCounted for equality");
            }
        };
    }

    public final class Leak
    implements Runnable {
        private static final AtomicReferenceFieldUpdater<Leak, Record> headUpdater = AtomicReferenceFieldUpdater.newUpdater(Leak.class, Record.class, "head");
        private static final AtomicIntegerFieldUpdater<Leak> droppedRecordsUpdater = AtomicIntegerFieldUpdater.newUpdater(Leak.class, "droppedRecords");
        private volatile Record head;
        private volatile int droppedRecords;
        private final AtomicBoolean closed = new AtomicBoolean(false);
        private final Cleaner.Cleanable cleanable;

        private Leak(Object referent) {
            this.cleanable = cleaner.register(referent, this);
            headUpdater.set(this, new Record(Record.BOTTOM));
        }

        @Override
        public void run() {
            if (!this.closed.compareAndSet(false, true) || !logger.isErrorEnabled()) {
                return;
            }
            String records = this.toString();
            if (LeakTracker.this.reportedLeaks.putIfAbsent(records, Boolean.TRUE) == null) {
                logger.error("LEAK: resource was not cleaned up before it was garbage-collected.{}", (Object)records);
            }
        }

        public void record() {
            boolean dropped;
            Record prevHead;
            Record newHead;
            Record oldHead;
            do {
                prevHead = oldHead = headUpdater.get(this);
                if (oldHead == null) {
                    return;
                }
                int numElements = oldHead.pos + 1;
                if (numElements >= 25) {
                    int backOffFactor = Math.min(numElements - 25, 30);
                    dropped = Randomness.get().nextInt(1 << backOffFactor) != 0;
                    if (!dropped) continue;
                    prevHead = oldHead.next;
                    continue;
                }
                dropped = false;
            } while (!headUpdater.compareAndSet(this, oldHead, newHead = new Record(prevHead)));
            if (dropped) {
                droppedRecordsUpdater.incrementAndGet(this);
            }
        }

        public boolean close() {
            if (this.closed.compareAndSet(false, true)) {
                this.cleanable.clean();
                headUpdater.set(this, null);
                return true;
            }
            return false;
        }

        public String toString() {
            Record oldHead = headUpdater.get(this);
            if (oldHead == null) {
                return "";
            }
            int dropped = droppedRecordsUpdater.get(this);
            int duped = 0;
            int present = oldHead.pos + 1;
            StringBuilder buf = new StringBuilder(present * 2048).append('\n');
            buf.append("Recent access records: ").append('\n');
            int i = 1;
            HashSet<String> seen = Sets.newHashSetWithExpectedSize(present);
            while (oldHead != Record.BOTTOM) {
                String s = oldHead.toString();
                if (seen.add(s)) {
                    if (oldHead.next == Record.BOTTOM) {
                        buf.append("Created at:").append('\n').append(s);
                    } else {
                        buf.append('#').append(i++).append(':').append('\n').append(s);
                    }
                } else {
                    ++duped;
                }
                oldHead = oldHead.next;
            }
            if (duped > 0) {
                buf.append(": ").append(duped).append(" leak records were discarded because they were duplicates").append('\n');
            }
            if (dropped > 0) {
                buf.append(": ").append(dropped).append(" leak records were discarded because the leak record count is targeted to ").append(25).append('.').append('\n');
            }
            buf.setLength(buf.length() - "\n".length());
            return buf.toString();
        }
    }

    private static final class Record
    extends Throwable {
        private static final Record BOTTOM = new Record();
        private final Record next;
        private final int pos;
        private final String threadName;
        private final String contextHint = contextHint;

        Record(Record next) {
            this.next = next;
            this.pos = next.pos + 1;
            this.threadName = Thread.currentThread().getName();
        }

        private Record() {
            this.next = null;
            this.pos = -1;
            this.threadName = Thread.currentThread().getName();
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder("\tin [").append(this.threadName).append("][").append(this.contextHint).append("]\n");
            StackTraceElement[] array = this.getStackTrace();
            for (int i = 3; i < array.length; ++i) {
                StackTraceElement element = array[i];
                buf.append('\t');
                buf.append(element.toString());
                buf.append('\n');
            }
            return buf.toString();
        }
    }
}

