/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class SnapshotFeatureInfo
implements Writeable,
ToXContentObject {
    final String pluginName;
    final List<String> indices;
    static final ConstructingObjectParser<SnapshotFeatureInfo, Void> SNAPSHOT_FEATURE_INFO_PARSER = new ConstructingObjectParser<SnapshotFeatureInfo, Void>("feature_info", true, (a, name) -> {
        String pluginName = (String)a[0];
        List indices = (List)a[1];
        return new SnapshotFeatureInfo(pluginName, indices);
    });

    public SnapshotFeatureInfo(String pluginName, List<String> indices) {
        this.pluginName = pluginName;
        this.indices = List.copyOf(indices);
    }

    public SnapshotFeatureInfo(StreamInput in) throws IOException {
        this(in.readString(), in.readStringCollectionAsImmutableList());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.pluginName);
        out.writeStringCollection(this.indices);
    }

    public static SnapshotFeatureInfo fromXContent(XContentParser parser) throws IOException {
        return SNAPSHOT_FEATURE_INFO_PARSER.parse(parser, null);
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public List<String> getIndices() {
        return this.indices;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("feature_name", this.pluginName);
        builder.startArray("indices");
        for (String index : this.indices) {
            builder.value(index);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SnapshotFeatureInfo)) {
            return false;
        }
        SnapshotFeatureInfo that = (SnapshotFeatureInfo)o;
        return this.getPluginName().equals(that.getPluginName()) && this.getIndices().equals(that.getIndices());
    }

    public int hashCode() {
        return Objects.hash(this.getPluginName(), this.getIndices());
    }

    static {
        SNAPSHOT_FEATURE_INFO_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("feature_name", new String[0]));
        SNAPSHOT_FEATURE_INFO_PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), new ParseField("indices", new String[0]));
    }
}

