/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.runtime;

import java.util.Objects;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.util.automaton.ByteRunAutomaton;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.StringFieldScript;
import org.elasticsearch.search.runtime.AbstractStringScriptFieldAutomatonQuery;

public class StringScriptFieldFuzzyQuery
extends AbstractStringScriptFieldAutomatonQuery {
    private final FuzzyQuery delegate;

    public static StringScriptFieldFuzzyQuery build(Script script, StringFieldScript.LeafFactory leafFactory, String fieldName, String term, int maxEdits, int prefixLength, boolean transpositions) {
        int maxExpansions = 1;
        FuzzyQuery delegate = new FuzzyQuery(new Term(fieldName, term), maxEdits, prefixLength, maxExpansions, transpositions);
        ByteRunAutomaton automaton = delegate.getAutomata().runAutomaton;
        return new StringScriptFieldFuzzyQuery(script, leafFactory, fieldName, automaton, delegate);
    }

    private StringScriptFieldFuzzyQuery(Script script, StringFieldScript.LeafFactory leafFactory, String fieldName, ByteRunAutomaton automaton, FuzzyQuery delegate) {
        super(script, leafFactory, fieldName, automaton);
        this.delegate = delegate;
    }

    @Override
    public final String toString(String field) {
        return this.delegate.toString(field);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.delegate);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        StringScriptFieldFuzzyQuery other = (StringScriptFieldFuzzyQuery)obj;
        return this.delegate.equals(other.delegate);
    }

    FuzzyQuery delegate() {
        return this.delegate;
    }
}

