/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase.highlight;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class HighlightField
implements ToXContentFragment,
Writeable {
    private final String name;
    private final Text[] fragments;

    public HighlightField(StreamInput in) throws IOException {
        this(in.readString(), in.readOptionalArray(StreamInput::readText, Text[]::new));
    }

    public HighlightField(String name, Text[] fragments) {
        this.name = Objects.requireNonNull(name, "missing highlight field name");
        this.fragments = fragments;
    }

    public String name() {
        return this.name;
    }

    public Text[] fragments() {
        return this.fragments;
    }

    public String toString() {
        return "[" + this.name + "], fragments[" + Arrays.toString(this.fragments) + "]";
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        if (this.fragments == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeArray(StreamOutput::writeText, this.fragments);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(this.name);
        if (this.fragments == null) {
            builder.nullValue();
        } else {
            builder.startArray();
            for (Text fragment : this.fragments) {
                builder.value(fragment);
            }
            builder.endArray();
        }
        return builder;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HighlightField other = (HighlightField)obj;
        return Objects.equals(this.name, other.name) && Arrays.equals(this.fragments, other.fragments);
    }

    public final int hashCode() {
        return Objects.hash(this.name, Arrays.hashCode(this.fragments));
    }
}

