/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

public abstract class ValuesSourceAggregatorFactory
extends AggregatorFactory {
    protected ValuesSourceConfig config;

    public ValuesSourceAggregatorFactory(String name, ValuesSourceConfig config, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, subFactoriesBuilder, metadata);
        this.config = config;
    }

    @Override
    public Aggregator createInternal(Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        if (!this.config.hasValues()) {
            return this.createUnmapped(parent, metadata);
        }
        return this.doCreateInternal(parent, cardinality, metadata);
    }

    protected abstract Aggregator createUnmapped(Aggregator var1, Map<String, Object> var2) throws IOException;

    protected abstract Aggregator doCreateInternal(Aggregator var1, CardinalityUpperBound var2, Map<String, Object> var3) throws IOException;

    @Override
    public String getStatsSubtype() {
        return this.config.valueSourceType().typeName();
    }
}

