/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline;

import java.util.List;
import java.util.Map;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.InternalSingleBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.SiblingPipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationPath;

public abstract class BucketMetricsPipelineAggregator
extends SiblingPipelineAggregator {
    protected final DocValueFormat format;
    protected final BucketHelpers.GapPolicy gapPolicy;

    BucketMetricsPipelineAggregator(String name, String[] bucketsPaths, BucketHelpers.GapPolicy gapPolicy, DocValueFormat format, Map<String, Object> metadata) {
        super(name, bucketsPaths, metadata);
        this.gapPolicy = gapPolicy;
        this.format = format;
    }

    @Override
    public final InternalAggregation doReduce(InternalAggregations aggregations, AggregationReduceContext context) {
        this.preCollection();
        List<AggregationPath.PathElement> parsedPath = AggregationPath.parse(this.bucketsPaths()[0]).getPathElements();
        for (Aggregation aggregation : aggregations) {
            if (!aggregation.getName().equals(parsedPath.get(0).name())) continue;
            int currElement = 0;
            Aggregation currentAgg = aggregation;
            while (currElement < parsedPath.size() - 1) {
                if (currentAgg == null) {
                    throw new AggregationExecutionException.InvalidPath("bucket_path [" + this.bucketsPaths()[0] + "] expected aggregation with name [" + parsedPath.get(currElement).name() + "] but was missing in search response");
                }
                if (currentAgg instanceof InternalSingleBucketAggregation) {
                    InternalSingleBucketAggregation singleBucketAggregation = (InternalSingleBucketAggregation)currentAgg;
                    currentAgg = singleBucketAggregation.getAggregations().get(parsedPath.get(++currElement).name());
                    continue;
                }
                if (!AggregationPath.pathElementContainsBucketKey(parsedPath.get(currElement))) break;
                if (currentAgg instanceof InternalMultiBucketAggregation) {
                    InternalMultiBucketAggregation multiBucketAggregation = (InternalMultiBucketAggregation)currentAgg;
                    InternalMultiBucketAggregation.InternalBucket bucket = (InternalMultiBucketAggregation.InternalBucket)multiBucketAggregation.getProperty(parsedPath.get(currElement).key());
                    if (bucket == null) {
                        throw new AggregationExecutionException.InvalidPath("missing bucket [" + parsedPath.get(currElement).key() + "] for agg [" + currentAgg.getName() + "] while extracting bucket path [" + this.bucketsPaths()[0] + "]");
                    }
                    if (currElement == parsedPath.size() - 1) {
                        throw new AggregationExecutionException("invalid bucket path ends at [" + parsedPath.get(currElement).key() + "]");
                    }
                    currentAgg = bucket.getAggregations().get(parsedPath.get(++currElement).name());
                    continue;
                }
                throw new AggregationExecutionException.InvalidPath("bucket_path [" + this.bucketsPaths()[0] + "] indicates bucket_key [" + parsedPath.get(currElement).key() + "] at position [" + currElement + "] but encountered on agg [" + currentAgg.getName() + "] which is not a multi_bucket aggregation");
            }
            if (!(currentAgg instanceof InternalMultiBucketAggregation)) {
                String msg = currentAgg == null ? "did not find multi-bucket aggregation for extraction." : "did not find multi-bucket aggregation for extraction. Found [" + currentAgg.getName() + "]";
                throw new AggregationExecutionException.InvalidPath(msg);
            }
            List<String> sublistedPath = AggregationPath.pathElementsAsStringList(parsedPath.subList(currElement, parsedPath.size()));
            sublistedPath = sublistedPath.subList(1, sublistedPath.size());
            InternalMultiBucketAggregation multiBucketsAgg = (InternalMultiBucketAggregation)currentAgg;
            List buckets = multiBucketsAgg.getBuckets();
            for (InternalMultiBucketAggregation.InternalBucket bucket : buckets) {
                Double bucketValue = BucketHelpers.resolveBucketValue((MultiBucketsAggregation)multiBucketsAgg, bucket, sublistedPath, this.gapPolicy);
                if (bucketValue == null || Double.isNaN(bucketValue)) continue;
                this.collectBucketValue(bucket.getKeyAsString(), bucketValue);
            }
        }
        return this.buildAggregation(this.metadata());
    }

    protected void preCollection() {
    }

    protected abstract InternalAggregation buildAggregation(Map<String, Object> var1);

    protected abstract void collectBucketValue(String var1, Double var2);
}

