/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class CryptUtils {
    private static final byte[] SALT = new byte[]{116, 104, 105, 115, 105, 115, 116, 104, 101, 115, 97, 108, 116, 119, 101, 117};
    private static final String KEY_ALGORITHM = "RSA";
    private static final char[] DEFAULT_PASS_PHRASE = "elasticsearch-license".toCharArray();
    private static final String KDF_ALGORITHM = "PBKDF2WithHmacSHA512";
    private static final int KDF_ITERATION_COUNT = 10000;
    private static final String CIPHER_ALGORITHM = "AES";
    private static final int ENCRYPTION_KEY_LENGTH = 128;
    private static final SecureRandom RANDOM = new SecureRandom();

    public static PrivateKey readEncryptedPrivateKey(byte[] fileContents) {
        return CryptUtils.readEncryptedPrivateKey(fileContents, DEFAULT_PASS_PHRASE, false);
    }

    public static byte[] writeEncryptedPrivateKey(PrivateKey privateKey) {
        return CryptUtils.writeEncryptedPrivateKey(privateKey, DEFAULT_PASS_PHRASE);
    }

    public static PrivateKey readEncryptedPrivateKey(byte[] fileContents, char[] passPhrase, boolean preV4) {
        byte[] keyBytes = preV4 ? CryptUtils.decryptV3Format(fileContents) : CryptUtils.decrypt(fileContents, passPhrase);
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(keyBytes);
        try {
            return KeyFactory.getInstance(KEY_ALGORITHM).generatePrivate(privateKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalStateException(e);
        }
    }

    public static PublicKey readPublicKey(byte[] fileContents) {
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(fileContents);
        try {
            return KeyFactory.getInstance(KEY_ALGORITHM).generatePublic(publicKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] writeEncryptedPublicKey(PublicKey publicKey) {
        X509EncodedKeySpec encodedKeySpec = new X509EncodedKeySpec(publicKey.getEncoded());
        return CryptUtils.encrypt(encodedKeySpec.getEncoded(), DEFAULT_PASS_PHRASE);
    }

    public static byte[] writeEncryptedPrivateKey(PrivateKey privateKey, char[] passPhrase) {
        PKCS8EncodedKeySpec encodedKeySpec = new PKCS8EncodedKeySpec(privateKey.getEncoded());
        return CryptUtils.encrypt(encodedKeySpec.getEncoded(), passPhrase);
    }

    static byte[] encrypt(byte[] data) {
        return CryptUtils.encrypt(data, DEFAULT_PASS_PHRASE);
    }

    static byte[] decrypt(byte[] encryptedData) {
        return CryptUtils.decrypt(encryptedData, DEFAULT_PASS_PHRASE);
    }

    private static byte[] encrypt(byte[] data, char[] passPhrase) {
        try {
            Cipher encryptionCipher = CryptUtils.getEncryptionCipher(CryptUtils.deriveSecretKey(passPhrase));
            return encryptionCipher.doFinal(data);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new IllegalStateException(e);
        }
    }

    private static byte[] decrypt(byte[] encryptedData, char[] passPhrase) {
        try {
            Cipher cipher = CryptUtils.getDecryptionCipher(CryptUtils.deriveSecretKey(passPhrase));
            return cipher.doFinal(encryptedData);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new IllegalStateException(e);
        }
    }

    static byte[] encryptV3Format(byte[] data) {
        try {
            SecretKey encryptionKey = CryptUtils.getV3Key();
            Cipher encryptionCipher = CryptUtils.getEncryptionCipher(encryptionKey);
            return encryptionCipher.doFinal(CryptUtils.pad(data, 20));
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    static byte[] decryptV3Format(byte[] data) {
        try {
            SecretKey decryptionKey = CryptUtils.getV3Key();
            Cipher decryptionCipher = CryptUtils.getDecryptionCipher(decryptionKey);
            return CryptUtils.unPad(decryptionCipher.doFinal(data));
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    private static SecretKey getV3Key() throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] salt = new byte[]{-87, -94, -75, -34, 42, -118, -102, -26};
        byte[] passBytes = "elasticsearch-license".getBytes(StandardCharsets.UTF_8);
        byte[] digest = MessageDigest.getInstance("SHA-512").digest(passBytes);
        char[] hashedPassphrase = Base64.getEncoder().encodeToString(digest).toCharArray();
        PBEKeySpec keySpec = new PBEKeySpec(hashedPassphrase, salt, 1024, 128);
        byte[] shortKey = SecretKeyFactory.getInstance("PBEWithSHA1AndDESede").generateSecret(keySpec).getEncoded();
        byte[] intermediaryKey = new byte[16];
        int j = 0;
        for (int i = 0; i < 16; ++i) {
            intermediaryKey[i] = shortKey[j];
            if (++j != shortKey.length) continue;
            j = 0;
        }
        return new SecretKeySpec(intermediaryKey, CIPHER_ALGORITHM);
    }

    private static SecretKey deriveSecretKey(char[] passPhrase) {
        try {
            PBEKeySpec keySpec = new PBEKeySpec(passPhrase, SALT, 10000, 128);
            SecretKey secretKey = SecretKeyFactory.getInstance(KDF_ALGORITHM).generateSecret(keySpec);
            return new SecretKeySpec(secretKey.getEncoded(), CIPHER_ALGORITHM);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Cipher getEncryptionCipher(SecretKey secretKey) {
        return CryptUtils.getCipher(1, secretKey);
    }

    private static Cipher getDecryptionCipher(SecretKey secretKey) {
        return CryptUtils.getCipher(2, secretKey);
    }

    private static Cipher getCipher(int mode, SecretKey secretKey) {
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            cipher.init(mode, (Key)secretKey, RANDOM);
            return cipher;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalStateException(e);
        }
    }

    private static byte[] pad(byte[] bytes, int length) {
        int i;
        if (bytes.length >= length) {
            byte[] out = new byte[bytes.length + 1];
            System.arraycopy(bytes, 0, out, 0, bytes.length);
            out[bytes.length] = 1;
            return out;
        }
        byte[] out = new byte[length + 1];
        for (i = 0; i < bytes.length; ++i) {
            out[i] = bytes[i];
        }
        int padded = length - i;
        byte[] fill = new byte[padded - 1];
        RANDOM.nextBytes(fill);
        System.arraycopy(fill, 0, out, i, padded - 1);
        out[length] = (byte)(padded + 1);
        return out;
    }

    private static byte[] unPad(byte[] bytes) {
        byte padded = bytes[bytes.length - 1];
        int targetLength = bytes.length - padded;
        byte[] out = new byte[targetLength];
        System.arraycopy(bytes, 0, out, 0, targetLength);
        return out;
    }
}

