/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip.shaded.com.maxmind.db;

import org.elasticsearch.ingest.geoip.shaded.com.maxmind.db.InvalidDatabaseException;

enum Type {
    EXTENDED,
    POINTER,
    UTF8_STRING,
    DOUBLE,
    BYTES,
    UINT16,
    UINT32,
    MAP,
    INT32,
    UINT64,
    UINT128,
    ARRAY,
    CONTAINER,
    END_MARKER,
    BOOLEAN,
    FLOAT;

    static final Type[] values;

    static Type get(int i) throws InvalidDatabaseException {
        if (i >= values.length) {
            throw new InvalidDatabaseException("The MaxMind DB file's data section contains bad data");
        }
        return values[i];
    }

    private static Type get(byte b) throws InvalidDatabaseException {
        return Type.get(b & 0xFF);
    }

    static Type fromControlByte(int b) throws InvalidDatabaseException {
        return Type.get((byte)((0xFF & b) >>> 5));
    }

    static {
        values = Type.values();
    }
}

