/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip.direct;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.ingest.geoip.direct.DatabaseConfiguration;
import org.elasticsearch.ingest.geoip.direct.DatabaseConfigurationMetadata;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetDatabaseConfigurationAction
extends ActionType<Response> {
    public static final GetDatabaseConfigurationAction INSTANCE = new GetDatabaseConfigurationAction();
    public static final String NAME = "cluster:admin/ingest/geoip/database/get";

    protected GetDatabaseConfigurationAction() {
        super(NAME);
    }

    public static class NodeResponse
    extends BaseNodeResponse {
        private final List<DatabaseConfigurationMetadata> databases;

        public NodeResponse(DiscoveryNode node, List<DatabaseConfigurationMetadata> databases) {
            super(node);
            this.databases = List.copyOf(databases);
        }

        public NodeResponse(StreamInput in) throws IOException {
            super(in);
            this.databases = in.readCollectionAsList(DatabaseConfigurationMetadata::new);
        }

        public List<DatabaseConfigurationMetadata> getDatabases() {
            return this.databases;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeCollection(this.databases);
        }

        public int hashCode() {
            return Objects.hash(this.databases);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            NodeResponse other = (NodeResponse)obj;
            return this.databases.equals(other.databases);
        }
    }

    public static class NodeRequest
    extends TransportRequest {
        private final String[] databaseIds;

        public NodeRequest(String ... databaseIds) {
            this.databaseIds = Objects.requireNonNull(databaseIds, "ids may not be null");
        }

        public NodeRequest(StreamInput in) throws IOException {
            super(in);
            this.databaseIds = in.readStringArray();
        }

        public String[] getDatabaseIds() {
            return this.databaseIds;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArray(this.databaseIds);
        }

        public int hashCode() {
            return Arrays.hashCode(this.databaseIds);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            NodeRequest other = (NodeRequest)obj;
            return Arrays.equals(this.databaseIds, other.databaseIds);
        }
    }

    public static class Response
    extends BaseNodesResponse<NodeResponse>
    implements ToXContentObject {
        private final List<DatabaseConfigurationMetadata> databases;

        public Response(List<DatabaseConfigurationMetadata> databases, ClusterName clusterName, List<NodeResponse> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
            this.databases = List.copyOf(databases);
        }

        protected Response(StreamInput in) throws IOException {
            super(in);
            this.databases = in.readCollectionAsList(DatabaseConfigurationMetadata::new);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeCollection(this.databases);
        }

        @Override
        protected List<NodeResponse> readNodesFrom(StreamInput in) throws IOException {
            return in.readCollectionAsList(NodeResponse::new);
        }

        @Override
        protected void writeNodesTo(StreamOutput out, List<NodeResponse> nodes) throws IOException {
            out.writeCollection(nodes);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startArray("databases");
            for (DatabaseConfigurationMetadata item : this.databases) {
                DatabaseConfiguration database = item.database();
                builder.startObject();
                builder.field("id", database.id());
                builder.field(DatabaseConfigurationMetadata.VERSION.getPreferredName(), item.version());
                builder.timestampFieldsFromUnixEpochMillis(DatabaseConfigurationMetadata.MODIFIED_DATE_MILLIS.getPreferredName(), DatabaseConfigurationMetadata.MODIFIED_DATE.getPreferredName(), item.modifiedDate());
                builder.field(DatabaseConfigurationMetadata.DATABASE.getPreferredName(), database);
                builder.endObject();
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return Objects.equals(this.databases, response.databases) && Objects.equals(this.getClusterName(), response.getClusterName()) && Objects.equals(this.equalsHashCodeFailures(), response.equalsHashCodeFailures()) && Objects.equals(this.getNodes(), response.getNodes()) && Objects.equals(this.equalsHashCodeNodesMap(), response.equalsHashCodeNodesMap());
        }

        public int hashCode() {
            return Objects.hash(this.databases, this.getClusterName(), this.equalsHashCodeFailures(), this.getNodes(), this.equalsHashCodeNodesMap());
        }

        private List<EqualsHashCodeFailedNodeException> equalsHashCodeFailures() {
            return this.failures().stream().map(EqualsHashCodeFailedNodeException::new).toList();
        }

        private synchronized Map<String, NodeResponse> equalsHashCodeNodesMap() {
            return this.getNodesMap();
        }

        private record EqualsHashCodeFailedNodeException(FailedNodeException failedNodeException) {
            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                EqualsHashCodeFailedNodeException other = (EqualsHashCodeFailedNodeException)o;
                return Objects.equals(this.failedNodeException.nodeId(), other.failedNodeException.nodeId()) && Objects.equals(this.failedNodeException.getMessage(), other.failedNodeException.getMessage());
            }

            @Override
            public int hashCode() {
                return Objects.hash(this.failedNodeException.nodeId(), this.failedNodeException.getMessage());
            }
        }
    }

    public static class Request
    extends BaseNodesRequest {
        private final String[] databaseIds;

        public Request(String ... databaseIds) {
            super((String[])null);
            this.databaseIds = databaseIds;
        }

        public String[] getDatabaseIds() {
            return this.databaseIds;
        }

        public int hashCode() {
            return Arrays.hashCode(this.databaseIds);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Request other = (Request)obj;
            return Arrays.equals(this.databaseIds, other.databaseIds);
        }
    }
}

