/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.Query;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.plugins.internal.rewriter.QueryRewriteInterceptor;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

class InterceptedQueryBuilderWrapper
implements QueryBuilder {
    protected final QueryBuilder queryBuilder;

    InterceptedQueryBuilderWrapper(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryBuilder rewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        QueryRewriteInterceptor queryRewriteInterceptor = queryRewriteContext.getQueryRewriteInterceptor();
        try {
            queryRewriteContext.setQueryRewriteInterceptor(null);
            QueryBuilder rewritten = this.queryBuilder.rewrite(queryRewriteContext);
            InterceptedQueryBuilderWrapper interceptedQueryBuilderWrapper = rewritten != this.queryBuilder ? new InterceptedQueryBuilderWrapper(rewritten) : this;
            return interceptedQueryBuilderWrapper;
        }
        finally {
            queryRewriteContext.setQueryRewriteInterceptor(queryRewriteInterceptor);
        }
    }

    @Override
    public String getWriteableName() {
        return this.queryBuilder.getWriteableName();
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return this.queryBuilder.getMinimalSupportedVersion();
    }

    @Override
    public Query toQuery(SearchExecutionContext context) throws IOException {
        return this.queryBuilder.toQuery(context);
    }

    @Override
    public QueryBuilder queryName(String queryName) {
        this.queryBuilder.queryName(queryName);
        return this;
    }

    @Override
    public String queryName() {
        return this.queryBuilder.queryName();
    }

    @Override
    public float boost() {
        return this.queryBuilder.boost();
    }

    @Override
    public QueryBuilder boost(float boost) {
        this.queryBuilder.boost(boost);
        return this;
    }

    @Override
    public String getName() {
        return this.queryBuilder.getName();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.queryBuilder.writeTo(out);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.queryBuilder.toXContent(builder, params);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InterceptedQueryBuilderWrapper)) {
            return false;
        }
        return Objects.equals(this.queryBuilder, ((InterceptedQueryBuilderWrapper)o).queryBuilder);
    }

    public int hashCode() {
        return Objects.hashCode(this.queryBuilder);
    }
}

