/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.StringHelper;
import org.elasticsearch.cluster.routing.IndexRouting;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.hash.Murmur3Hasher;
import org.elasticsearch.common.hash.MurmurHash3;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.util.ByteUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.RoutingFields;
import org.elasticsearch.search.DocValueFormat;

public final class RoutingPathFields
implements RoutingFields {
    private static final int SEED = 0;
    private static final int MAX_ROUTING_FIELDS = 512;
    private static final int MAX_HASH_LEN_BYTES = 2;
    private final SortedMap<BytesRef, List<BytesReference>> routingValues = new TreeMap<BytesRef, List<BytesReference>>();
    @Nullable
    private final IndexRouting.ExtractFromSource.Builder routingBuilder;
    static final /* synthetic */ boolean $assertionsDisabled;

    public RoutingPathFields(@Nullable IndexRouting.ExtractFromSource.Builder routingBuilder) {
        this.routingBuilder = routingBuilder;
    }

    SortedMap<BytesRef, List<BytesReference>> routingValues() {
        return Collections.unmodifiableSortedMap(this.routingValues);
    }

    IndexRouting.ExtractFromSource.Builder routingBuilder() {
        return this.routingBuilder;
    }

    public BytesReference buildHash() {
        Murmur3Hasher hasher = new Murmur3Hasher(0L);
        int numberOfFields = Math.min(512, this.routingValues.size());
        int len = RoutingPathFields.hashLen(numberOfFields);
        byte[] hash = new byte[2 + len];
        int index = StreamOutput.putVInt(hash, len, 0);
        hasher.reset();
        for (BytesRef name : this.routingValues.keySet()) {
            hasher.update(name.bytes);
        }
        int startIndex = index = RoutingPathFields.writeHash128(hasher.digestHash(), hash, index);
        for (List<BytesReference> values : this.routingValues.values()) {
            if (index - startIndex >= 4 * numberOfFields) break;
            if (!$assertionsDisabled && values.isEmpty()) {
                throw new AssertionError((Object)"routing values are empty");
            }
            BytesRef routingValue = values.get(0).toBytesRef();
            ByteUtils.writeIntLE(StringHelper.murmurhash3_x86_32(routingValue.bytes, routingValue.offset, routingValue.length, 0), hash, index);
            index += 4;
        }
        hasher.reset();
        for (List<BytesReference> values : this.routingValues.values()) {
            for (BytesReference v : values) {
                hasher.update(v.toBytesRef().bytes);
            }
        }
        index = RoutingPathFields.writeHash128(hasher.digestHash(), hash, index);
        return new BytesArray(hash, 0, index);
    }

    private static int hashLen(int numberOfFields) {
        return 32 + 4 * numberOfFields;
    }

    private static int writeHash128(MurmurHash3.Hash128 hash128, byte[] buffer, int index) {
        ByteUtils.writeLongLE(hash128.h1, buffer, index);
        ByteUtils.writeLongLE(hash128.h2, buffer, index += 8);
        return index += 8;
    }

    @Override
    public RoutingFields addString(String fieldName, BytesRef utf8Value) {
        try (BytesStreamOutput out = new BytesStreamOutput();){
            out.write(115);
            out.writeBytesRef(utf8Value);
            this.add(fieldName, out.bytes());
            if (this.routingBuilder != null) {
                this.routingBuilder.addMatching(fieldName, utf8Value);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Routing field cannot be serialized.", e);
        }
        return this;
    }

    @Override
    public RoutingFields addIp(String fieldName, InetAddress value) {
        return this.addString(fieldName, NetworkAddress.format(value));
    }

    @Override
    public RoutingFields addLong(String fieldName, long value) {
        try (BytesStreamOutput out = new BytesStreamOutput();){
            out.write(108);
            out.writeLong(value);
            this.add(fieldName, out.bytes());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Routing field cannot be serialized.", e);
        }
        return this;
    }

    @Override
    public RoutingFields addUnsignedLong(String fieldName, long value) {
        BytesStreamOutput out = new BytesStreamOutput();
        try {
            Object ul = DocValueFormat.UNSIGNED_LONG_SHIFTED.format(value);
            if (ul instanceof Long) {
                Long l = (Long)ul;
                out.write(108);
                out.writeLong(l);
            } else {
                out.write(117);
                out.writeLong(value);
            }
            this.add(fieldName, out.bytes());
            RoutingPathFields routingPathFields = this;
            out.close();
            return routingPathFields;
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Routing field cannot be serialized.", e);
            }
        }
    }

    @Override
    public RoutingFields addBoolean(String fieldName, boolean value) {
        try (BytesStreamOutput out = new BytesStreamOutput();){
            out.write(98);
            out.write(value ? 116 : 102);
            this.add(fieldName, out.bytes());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Routing field cannot be serialized.", e);
        }
        return this;
    }

    private void add(String fieldName, BytesReference encoded) throws IOException {
        BytesRef name = new BytesRef(fieldName);
        ArrayList<BytesReference> values = (ArrayList<BytesReference>)this.routingValues.get(name);
        if (values == null) {
            this.routingValues.put(name, List.of(encoded));
        } else {
            if (values.size() == 1) {
                BytesReference previousValue = (BytesReference)values.get(0);
                values = new ArrayList<BytesReference>(4);
                values.add(previousValue);
                this.routingValues.put(name, values);
            }
            values.add(encoded);
        }
    }

    public static Map<String, Object> decodeAsMap(BytesRef bytesRef) {
        LinkedHashMap<String, Object> linkedHashMap;
        block20: {
            StreamInput in = new BytesArray(bytesRef).streamInput();
            try {
                int size = in.readVInt();
                LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(size);
                block18: for (int i = 0; i < size; ++i) {
                    String name = null;
                    try {
                        name = in.readSlicedBytesReference().utf8ToString();
                    }
                    catch (AssertionError ae) {
                        throw new IllegalArgumentException("Error parsing routing field: " + ((Throwable)((Object)ae)).getMessage(), (Throwable)((Object)ae));
                    }
                    int type = in.read();
                    switch (type) {
                        case 115: {
                            try {
                                result.put(name, in.readSlicedBytesReference().utf8ToString());
                                continue block18;
                            }
                            catch (AssertionError ae) {
                                throw new IllegalArgumentException("Error parsing routing field: " + ((Throwable)((Object)ae)).getMessage(), (Throwable)((Object)ae));
                            }
                        }
                        case 108: {
                            result.put(name, in.readLong());
                            continue block18;
                        }
                        case 117: {
                            Object ul = DocValueFormat.UNSIGNED_LONG_SHIFTED.format(in.readLong());
                            result.put(name, ul);
                            continue block18;
                        }
                        case 100: {
                            result.put(name, in.readDouble());
                            continue block18;
                        }
                        case 98: {
                            result.put(name, in.read() == 116);
                            continue block18;
                        }
                        default: {
                            throw new IllegalArgumentException("Cannot parse [" + name + "]: Unknown type [" + type + "]");
                        }
                    }
                }
                linkedHashMap = result;
                if (in == null) break block20;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | IllegalArgumentException e) {
                    throw new IllegalArgumentException("Routing field cannot be deserialized:" + e.getMessage(), e);
                }
            }
            in.close();
        }
        return linkedHashMap;
    }

    static {
        boolean bl = $assertionsDisabled = !RoutingPathFields.class.desiredAssertionStatus();
        if (!$assertionsDisabled && 2 != StreamOutput.putVInt(new byte[2], RoutingPathFields.hashLen(512), 0)) {
            throw new AssertionError();
        }
    }
}

