/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;

final class CompositeIndexEventListener
implements IndexEventListener {
    private final List<IndexEventListener> listeners;
    private final Logger logger;

    CompositeIndexEventListener(IndexSettings indexSettings, Collection<IndexEventListener> listeners) {
        for (IndexEventListener listener : listeners) {
            if (listener != null) continue;
            throw new IllegalArgumentException("listeners must be non-null");
        }
        this.listeners = List.copyOf(listeners);
        this.logger = Loggers.getLogger(this.getClass(), indexSettings.getIndex(), new String[0]);
    }

    @Override
    public void shardRoutingChanged(IndexShard indexShard, @Nullable ShardRouting oldRouting, ShardRouting newRouting) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.shardRoutingChanged(indexShard, oldRouting, newRouting);
            }
            catch (Exception e) {
                this.logger.warn(() -> "[" + indexShard.shardId().getId() + "] failed to invoke shard touring changed callback", (Throwable)e);
            }
        }
    }

    @Override
    public void afterIndexShardCreated(IndexShard indexShard) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.afterIndexShardCreated(indexShard);
            }
            catch (Exception e) {
                this.logger.warn(() -> "[" + indexShard.shardId().getId() + "] failed to invoke after shard created callback", (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public void afterIndexShardStarted(IndexShard indexShard) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.afterIndexShardStarted(indexShard);
            }
            catch (Exception e) {
                this.logger.warn(() -> "[" + indexShard.shardId().getId() + "] failed to invoke after shard started callback", (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.beforeIndexShardClosed(shardId, indexShard, indexSettings);
            }
            catch (Exception e) {
                this.logger.warn(() -> "[" + shardId.getId() + "] failed to invoke before shard closed callback", (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public void afterIndexShardClosing(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.afterIndexShardClosing(shardId, indexShard, indexSettings);
            }
            catch (Exception e) {
                this.logger.warn(() -> "[" + shardId.getId() + "] failed to invoke after shard closing callback", (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public void afterIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.afterIndexShardClosed(shardId, indexShard, indexSettings);
            }
            catch (Exception e) {
                this.logger.warn(() -> "[" + shardId.getId() + "] failed to invoke after shard closed callback", (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public void indexShardStateChanged(IndexShard indexShard, @Nullable IndexShardState previousState, IndexShardState currentState, @Nullable String reason) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.indexShardStateChanged(indexShard, previousState, indexShard.state(), reason);
            }
            catch (Exception e) {
                this.logger.warn(() -> Strings.format("[%s] failed to invoke index shard state changed callback", indexShard.shardId().getId()), (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public void beforeIndexCreated(Index index, Settings indexSettings) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.beforeIndexCreated(index, indexSettings);
            }
            catch (Exception e) {
                this.logger.warn("failed to invoke before index created callback", (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public void afterIndexCreated(IndexService indexService) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.afterIndexCreated(indexService);
            }
            catch (Exception e) {
                this.logger.warn("failed to invoke after index created callback", (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public void beforeIndexShardCreated(ShardRouting shardRouting, Settings indexSettings) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.beforeIndexShardCreated(shardRouting, indexSettings);
            }
            catch (Exception e) {
                this.logger.warn(() -> "[" + String.valueOf(shardRouting) + "] failed to invoke before shard created callback", (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public void beforeIndexRemoved(IndexService indexService, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason reason) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.beforeIndexRemoved(indexService, reason);
            }
            catch (Exception e) {
                this.logger.warn("failed to invoke before index removed callback", (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public void afterIndexRemoved(Index index, IndexSettings indexSettings, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason reason) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.afterIndexRemoved(index, indexSettings, reason);
            }
            catch (Exception e) {
                this.logger.warn("failed to invoke after index removed callback", (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public void beforeIndexShardDeleted(ShardId shardId, Settings indexSettings) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.beforeIndexShardDeleted(shardId, indexSettings);
            }
            catch (Exception e) {
                this.logger.warn(() -> "[" + shardId.getId() + "] failed to invoke before shard deleted callback", (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public void afterIndexShardDeleted(ShardId shardId, Settings indexSettings) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.afterIndexShardDeleted(shardId, indexSettings);
            }
            catch (Exception e) {
                this.logger.warn(() -> "[" + shardId.getId() + "] failed to invoke after shard deleted callback", (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public void beforeIndexAddedToCluster(Index index, Settings indexSettings) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.beforeIndexAddedToCluster(index, indexSettings);
            }
            catch (Exception e) {
                this.logger.warn("failed to invoke before index added to cluster callback", (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public void onStoreCreated(ShardId shardId) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.onStoreCreated(shardId);
            }
            catch (Exception e) {
                this.logger.warn("failed to invoke on store created", (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public void onStoreClosed(ShardId shardId) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.onStoreClosed(shardId);
            }
            catch (Exception e) {
                this.logger.warn("failed to invoke on store closed", (Throwable)e);
                throw e;
            }
        }
    }

    private static void callListeners(IndexShard indexShard, Iterator<Consumer<ActionListener<Void>>> iterator, ActionListener<Void> outerListener) {
        while (iterator.hasNext()) {
            Consumer<ActionListener<Void>> nextListener = iterator.next();
            ListenableFuture<Void> future = new ListenableFuture<Void>();
            try {
                nextListener.accept(future);
                if (future.isDone()) {
                    future.result();
                    continue;
                }
            }
            catch (Exception e) {
                outerListener.onFailure(e);
                return;
            }
            future.addListener(outerListener.delegateFailure((delegate, v) -> indexShard.getThreadPool().executor("generic").execute(ActionRunnable.wrap(delegate, l -> CompositeIndexEventListener.callListeners(indexShard, iterator, l)))));
            return;
        }
        outerListener.onResponse(null);
    }

    private void iterateBeforeIndexShardRecovery(IndexShard indexShard, IndexSettings indexSettings, List<IndexEventListener> listeners, ActionListener<Void> outerListener) {
        CompositeIndexEventListener.callListeners(indexShard, listeners.stream().map(iel -> l -> iel.beforeIndexShardRecovery(indexShard, indexSettings, (ActionListener<Void>)l)).iterator(), outerListener);
    }

    private void iterateAfterIndexShardRecovery(IndexShard indexShard, List<IndexEventListener> listeners, ActionListener<Void> outerListener) {
        CompositeIndexEventListener.callListeners(indexShard, listeners.stream().map(iel -> l -> iel.afterIndexShardRecovery(indexShard, (ActionListener<Void>)l)).iterator(), outerListener);
    }

    @Override
    public void beforeIndexShardRecovery(IndexShard indexShard, IndexSettings indexSettings, ActionListener<Void> outerListener) {
        this.iterateBeforeIndexShardRecovery(indexShard, indexSettings, this.listeners, outerListener.delegateResponse((l, e) -> {
            this.logger.warn(() -> Strings.format("failed to invoke the listener before the shard recovery starts for %s", indexShard.shardId()), (Throwable)e);
            l.onFailure((Exception)e);
        }));
    }

    @Override
    public void afterIndexShardRecovery(IndexShard indexShard, ActionListener<Void> outerListener) {
        this.iterateAfterIndexShardRecovery(indexShard, this.listeners, outerListener.delegateResponse((l, e) -> {
            this.logger.warn(() -> Strings.format("failed to invoke the listener after the shard recovery for %s", indexShard.shardId()), (Throwable)e);
            l.onFailure((Exception)e);
        }));
    }

    @Override
    public void afterFilesRestoredFromRepository(IndexShard indexShard) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.afterFilesRestoredFromRepository(indexShard);
            }
            catch (Exception e) {
                this.logger.warn(() -> "[" + String.valueOf(indexShard.shardId()) + "] failed to invoke after files restored from repository", (Throwable)e);
                throw e;
            }
        }
    }
}

