/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.env;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileStoreAttributeView;
import java.util.List;
import org.apache.lucene.util.Constants;
import org.elasticsearch.core.PathUtils;
import org.elasticsearch.core.SuppressForbidden;

class ESFileStore
extends FileStore {
    final FileStore in;
    private int majorDeviceNumber;
    private int minorDeviceNumber;

    @SuppressForbidden(reason="tries to determine if disk is spinning")
    ESFileStore(FileStore in) {
        this.in = in;
        if (Constants.LINUX) {
            try {
                List<String> lines = Files.readAllLines(PathUtils.get("/proc/self/mountinfo", new String[0]));
                for (String line : lines) {
                    String[] fields = line.trim().split("\\s+");
                    String mountPoint = fields[4];
                    if (!mountPoint.equals(ESFileStore.getMountPointLinux(in))) continue;
                    String[] deviceNumbers = fields[2].split(":");
                    this.majorDeviceNumber = Integer.parseInt(deviceNumbers[0]);
                    this.minorDeviceNumber = Integer.parseInt(deviceNumbers[1]);
                }
            }
            catch (Exception e) {
                this.majorDeviceNumber = -1;
                this.minorDeviceNumber = -1;
            }
        } else {
            this.majorDeviceNumber = -1;
            this.minorDeviceNumber = -1;
        }
    }

    private static String getMountPointLinux(FileStore store) {
        String desc = store.toString();
        int index = desc.lastIndexOf(" (");
        if (index != -1) {
            return desc.substring(0, index);
        }
        return desc;
    }

    @Override
    public String name() {
        return this.in.name();
    }

    @Override
    public String type() {
        return this.in.type();
    }

    @Override
    public boolean isReadOnly() {
        return this.in.isReadOnly();
    }

    @Override
    public long getTotalSpace() throws IOException {
        long result = this.in.getTotalSpace();
        if (result < 0L) {
            result = Long.MAX_VALUE;
        }
        return result;
    }

    @Override
    public long getUsableSpace() throws IOException {
        long result = this.in.getUsableSpace();
        if (result < 0L) {
            result = Long.MAX_VALUE;
        }
        return result;
    }

    @Override
    public long getUnallocatedSpace() throws IOException {
        long result = this.in.getUnallocatedSpace();
        if (result < 0L) {
            result = Long.MAX_VALUE;
        }
        return result;
    }

    @Override
    public boolean supportsFileAttributeView(Class<? extends FileAttributeView> type) {
        return this.in.supportsFileAttributeView(type);
    }

    @Override
    public boolean supportsFileAttributeView(String name) {
        if ("lucene".equals(name)) {
            return true;
        }
        return this.in.supportsFileAttributeView(name);
    }

    @Override
    public <V extends FileStoreAttributeView> V getFileStoreAttributeView(Class<V> type) {
        return this.in.getFileStoreAttributeView(type);
    }

    @Override
    public Object getAttribute(String attribute) throws IOException {
        return switch (attribute) {
            case "lucene:major_device_number" -> this.majorDeviceNumber;
            case "lucene:minor_device_number" -> this.minorDeviceNumber;
            default -> this.in.getAttribute(attribute);
        };
    }

    public String toString() {
        return this.in.toString();
    }
}

