/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.datastreams.ModifyDataStreamsAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.AckedBatchedClusterStateUpdateTask;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateAckListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.SimpleBatchedAckListenerTaskExecutor;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamAction;
import org.elasticsearch.cluster.metadata.DataStreamGlobalRetentionSettings;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.cluster.metadata.DataStreamOptions;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataDeleteIndexService;
import org.elasticsearch.cluster.metadata.MetadataMigrateToDataStreamService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.snapshots.SnapshotInProgressException;
import org.elasticsearch.snapshots.SnapshotsService;

public class MetadataDataStreamsService {
    private static final Logger LOGGER = LogManager.getLogger(MetadataDataStreamsService.class);
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final DataStreamGlobalRetentionSettings globalRetentionSettings;
    private final MasterServiceTaskQueue<UpdateLifecycleTask> updateLifecycleTaskQueue;
    private final MasterServiceTaskQueue<SetRolloverOnWriteTask> setRolloverOnWriteTaskQueue;
    private final MasterServiceTaskQueue<UpdateOptionsTask> updateOptionsTaskQueue;

    public MetadataDataStreamsService(ClusterService clusterService, IndicesService indicesService, DataStreamGlobalRetentionSettings globalRetentionSettings) {
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.globalRetentionSettings = globalRetentionSettings;
        SimpleBatchedAckListenerTaskExecutor<UpdateLifecycleTask> updateLifecycleExecutor = new SimpleBatchedAckListenerTaskExecutor<UpdateLifecycleTask>(){

            @Override
            public Tuple<ClusterState, ClusterStateAckListener> executeTask(UpdateLifecycleTask modifyLifecycleTask, ClusterState clusterState) {
                return new Tuple<ClusterState, ClusterStateAckListener>(MetadataDataStreamsService.this.updateDataLifecycle(clusterState, modifyLifecycleTask.getDataStreamNames(), modifyLifecycleTask.getDataLifecycle()), modifyLifecycleTask);
            }
        };
        this.updateLifecycleTaskQueue = clusterService.createTaskQueue("modify-lifecycle", Priority.HIGH, updateLifecycleExecutor);
        SimpleBatchedAckListenerTaskExecutor<SetRolloverOnWriteTask> rolloverOnWriteExecutor = new SimpleBatchedAckListenerTaskExecutor<SetRolloverOnWriteTask>(this){

            @Override
            public Tuple<ClusterState, ClusterStateAckListener> executeTask(SetRolloverOnWriteTask setRolloverOnWriteTask, ClusterState clusterState) {
                return new Tuple<ClusterState, ClusterStateAckListener>(MetadataDataStreamsService.setRolloverOnWrite(clusterState, setRolloverOnWriteTask.getDataStreamName(), setRolloverOnWriteTask.rolloverOnWrite(), setRolloverOnWriteTask.targetFailureStore()), setRolloverOnWriteTask);
            }
        };
        this.setRolloverOnWriteTaskQueue = clusterService.createTaskQueue("data-stream-rollover-on-write", Priority.NORMAL, rolloverOnWriteExecutor);
        SimpleBatchedAckListenerTaskExecutor<UpdateOptionsTask> updateOptionsExecutor = new SimpleBatchedAckListenerTaskExecutor<UpdateOptionsTask>(){

            @Override
            public Tuple<ClusterState, ClusterStateAckListener> executeTask(UpdateOptionsTask modifyOptionsTask, ClusterState clusterState) {
                return new Tuple<ClusterState, ClusterStateAckListener>(MetadataDataStreamsService.this.updateDataStreamOptions(clusterState, modifyOptionsTask.getDataStreamNames(), modifyOptionsTask.getOptions()), modifyOptionsTask);
            }
        };
        this.updateOptionsTaskQueue = clusterService.createTaskQueue("modify-data-stream-options", Priority.NORMAL, updateOptionsExecutor);
    }

    public void modifyDataStream(final ModifyDataStreamsAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        if (request.getActions().size() == 0) {
            listener.onResponse(AcknowledgedResponse.TRUE);
        } else {
            this.submitUnbatchedTask("update-backing-indices", new AckedClusterStateUpdateTask(Priority.URGENT, request, listener){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    return MetadataDataStreamsService.modifyDataStream(currentState, request.getActions(), indexMetadata -> {
                        try {
                            return MetadataDataStreamsService.this.indicesService.createIndexMapperServiceForValidation((IndexMetadata)indexMetadata);
                        }
                        catch (IOException e) {
                            throw new IllegalStateException(e);
                        }
                    }, MetadataDataStreamsService.this.clusterService.getSettings());
                }
            });
        }
    }

    public void setLifecycle(List<String> dataStreamNames, DataStreamLifecycle lifecycle, TimeValue ackTimeout, TimeValue masterTimeout, ActionListener<AcknowledgedResponse> listener) {
        this.updateLifecycleTaskQueue.submitTask("set-lifecycle", new UpdateLifecycleTask(dataStreamNames, lifecycle, ackTimeout, listener), masterTimeout);
    }

    public void removeLifecycle(List<String> dataStreamNames, TimeValue ackTimeout, TimeValue masterTimeout, ActionListener<AcknowledgedResponse> listener) {
        this.updateLifecycleTaskQueue.submitTask("delete-lifecycle", new UpdateLifecycleTask(dataStreamNames, null, ackTimeout, listener), masterTimeout);
    }

    public void setDataStreamOptions(List<String> dataStreamNames, DataStreamOptions options, TimeValue ackTimeout, TimeValue masterTimeout, ActionListener<AcknowledgedResponse> listener) {
        this.updateOptionsTaskQueue.submitTask("set-data-stream-options", new UpdateOptionsTask(dataStreamNames, options, ackTimeout, listener), masterTimeout);
    }

    public void removeDataStreamOptions(List<String> dataStreamNames, TimeValue ackTimeout, TimeValue masterTimeout, ActionListener<AcknowledgedResponse> listener) {
        this.updateOptionsTaskQueue.submitTask("delete-data-stream-options", new UpdateOptionsTask(dataStreamNames, null, ackTimeout, listener), masterTimeout);
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    public void setRolloverOnWrite(String dataStreamName, boolean rolloverOnWrite, boolean targetFailureStore, TimeValue ackTimeout, TimeValue masterTimeout, ActionListener<AcknowledgedResponse> listener) {
        this.setRolloverOnWriteTaskQueue.submitTask("set-rollover-on-write", new SetRolloverOnWriteTask(dataStreamName, rolloverOnWrite, targetFailureStore, ackTimeout, listener), masterTimeout);
    }

    static ClusterState modifyDataStream(ClusterState currentState, Iterable<DataStreamAction> actions, Function<IndexMetadata, MapperService> mapperSupplier, Settings nodeSettings) {
        Metadata updatedMetadata = currentState.metadata();
        for (DataStreamAction action : actions) {
            Metadata.Builder builder = Metadata.builder(updatedMetadata);
            if (action.getType() == DataStreamAction.Type.ADD_BACKING_INDEX) {
                MetadataDataStreamsService.addBackingIndex(updatedMetadata, builder, mapperSupplier, action.getDataStream(), action.getIndex(), action.isFailureStore(), nodeSettings);
            } else if (action.getType() == DataStreamAction.Type.REMOVE_BACKING_INDEX) {
                MetadataDataStreamsService.removeBackingIndex(updatedMetadata, builder, action.getDataStream(), action.getIndex(), action.isFailureStore());
            } else {
                throw new IllegalStateException("unsupported data stream action type [" + action.getClass().getName() + "]");
            }
            updatedMetadata = builder.build();
        }
        return ClusterState.builder(currentState).metadata(updatedMetadata).build();
    }

    ClusterState updateDataLifecycle(ClusterState currentState, List<String> dataStreamNames, @Nullable DataStreamLifecycle lifecycle) {
        Metadata metadata = currentState.metadata();
        Metadata.Builder builder = Metadata.builder(metadata);
        boolean onlyInternalDataStreams = true;
        for (String dataStreamName : dataStreamNames) {
            DataStream dataStream = MetadataDataStreamsService.validateDataStream(metadata, dataStreamName);
            builder.put(dataStream.copy().setLifecycle(lifecycle).build());
            onlyInternalDataStreams = onlyInternalDataStreams && dataStream.isInternal();
        }
        if (lifecycle != null) {
            lifecycle.addWarningHeaderIfDataRetentionNotEffective(this.globalRetentionSettings.get(), onlyInternalDataStreams);
        }
        return ClusterState.builder(currentState).metadata(builder.build()).build();
    }

    ClusterState updateDataStreamOptions(ClusterState currentState, List<String> dataStreamNames, @Nullable DataStreamOptions dataStreamOptions) {
        Metadata metadata = currentState.metadata();
        Metadata.Builder builder = Metadata.builder(metadata);
        for (String dataStreamName : dataStreamNames) {
            DataStream dataStream = MetadataDataStreamsService.validateDataStream(metadata, dataStreamName);
            builder.put(dataStream.copy().setDataStreamOptions(dataStreamOptions).build());
        }
        return ClusterState.builder(currentState).metadata(builder.build()).build();
    }

    public static ClusterState setRolloverOnWrite(ClusterState currentState, String dataStreamName, boolean rolloverOnWrite, boolean targetFailureStore) {
        Metadata metadata = currentState.metadata();
        DataStream dataStream = MetadataDataStreamsService.validateDataStream(metadata, dataStreamName);
        DataStream.DataStreamIndices indices = dataStream.getDataStreamIndices(targetFailureStore);
        if (indices.isRolloverOnWrite() == rolloverOnWrite) {
            return currentState;
        }
        Metadata.Builder builder = Metadata.builder(metadata);
        builder.put(dataStream.copy().setDataStreamIndices(targetFailureStore, indices.copy().setRolloverOnWrite(rolloverOnWrite).build()).build());
        return ClusterState.builder(currentState).metadata(builder.build()).build();
    }

    private static void addBackingIndex(Metadata metadata, Metadata.Builder builder, Function<IndexMetadata, MapperService> mapperSupplier, String dataStreamName, String indexName, boolean failureStore, Settings nodeSettings) {
        DataStream dataStream = MetadataDataStreamsService.validateDataStream(metadata, dataStreamName);
        IndexAbstraction index = MetadataDataStreamsService.validateIndex(metadata, indexName);
        try {
            MetadataMigrateToDataStreamService.prepareBackingIndex(builder, metadata.index(index.getWriteIndex()), dataStreamName, mapperSupplier, false, failureStore, dataStream.isSystem(), nodeSettings);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("unable to prepare backing index", e);
        }
        if (failureStore) {
            builder.put(dataStream.addFailureStoreIndex(metadata, index.getWriteIndex()));
        } else {
            builder.put(dataStream.addBackingIndex(metadata, index.getWriteIndex()));
        }
    }

    private static void removeBackingIndex(Metadata metadata, Metadata.Builder builder, String dataStreamName, String indexName, boolean failureStore) {
        boolean indexNotRemoved = true;
        DataStream dataStream = MetadataDataStreamsService.validateDataStream(metadata, dataStreamName);
        List<Index> targetIndices = failureStore ? dataStream.getFailureIndices() : dataStream.getIndices();
        for (Index backingIndex : targetIndices) {
            if (!backingIndex.getName().equals(indexName)) continue;
            if (failureStore) {
                builder.put(dataStream.removeFailureStoreIndex(backingIndex));
            } else {
                builder.put(dataStream.removeBackingIndex(backingIndex));
            }
            indexNotRemoved = false;
            break;
        }
        if (indexNotRemoved) {
            throw new IllegalArgumentException("index [" + indexName + "] not found");
        }
        IndexMetadata indexMetadata = builder.get(indexName);
        if (indexMetadata != null) {
            builder.put(IndexMetadata.builder(indexMetadata).settings(Settings.builder().put(indexMetadata.getSettings()).put("index.hidden", "false").build()).settingsVersion(indexMetadata.getSettingsVersion() + 1L));
        }
    }

    private static DataStream validateDataStream(Metadata metadata, String dataStreamName) {
        IndexAbstraction dataStream = (IndexAbstraction)metadata.getIndicesLookup().get(dataStreamName);
        if (dataStream == null || dataStream.getType() != IndexAbstraction.Type.DATA_STREAM) {
            throw new IllegalArgumentException("data stream [" + dataStreamName + "] not found");
        }
        return (DataStream)dataStream;
    }

    private static IndexAbstraction validateIndex(Metadata metadata, String indexName) {
        IndexAbstraction index = (IndexAbstraction)metadata.getIndicesLookup().get(indexName);
        if (index == null || index.getType() != IndexAbstraction.Type.CONCRETE_INDEX) {
            throw new IllegalArgumentException("index [" + indexName + "] not found");
        }
        return index;
    }

    public static ClusterState deleteDataStreams(ClusterState currentState, Set<DataStream> dataStreams, Settings settings) {
        if (dataStreams.isEmpty()) {
            return currentState;
        }
        Set<String> dataStreamNames = dataStreams.stream().map(DataStream::getName).collect(Collectors.toSet());
        Set<String> snapshottingDataStreams = SnapshotsService.snapshottingDataStreams(currentState, dataStreamNames);
        if (!snapshottingDataStreams.isEmpty()) {
            throw new SnapshotInProgressException("Cannot delete data streams that are being snapshotted: [" + String.join((CharSequence)", ", snapshottingDataStreams) + "]. Try again after snapshot finishes or cancel the currently running snapshot.");
        }
        HashSet<Index> backingIndicesToRemove = new HashSet<Index>();
        for (DataStream dataStream : dataStreams) {
            assert (dataStream != null);
            if (currentState.metadata().dataStreams().get(dataStream.getName()) == null) {
                throw new ResourceNotFoundException("data stream [" + dataStream.getName() + "] not found", new Object[0]);
            }
            backingIndicesToRemove.addAll(dataStream.getIndices());
            backingIndicesToRemove.addAll(dataStream.getFailureIndices());
        }
        Metadata.Builder metadata = Metadata.builder(currentState.metadata());
        for (DataStream ds : dataStreams) {
            LOGGER.info("removing data stream [{}]", new Object[]{ds.getName()});
            metadata.removeDataStream(ds.getName());
        }
        currentState = ClusterState.builder(currentState).metadata(metadata).build();
        return MetadataDeleteIndexService.deleteIndices(currentState, backingIndicesToRemove, settings);
    }

    static class UpdateLifecycleTask
    extends AckedBatchedClusterStateUpdateTask {
        private final List<String> dataStreamNames;
        private final DataStreamLifecycle lifecycle;

        UpdateLifecycleTask(List<String> dataStreamNames, @Nullable DataStreamLifecycle lifecycle, TimeValue ackTimeout, ActionListener<AcknowledgedResponse> listener) {
            super(ackTimeout, listener);
            this.dataStreamNames = dataStreamNames;
            this.lifecycle = lifecycle;
        }

        public List<String> getDataStreamNames() {
            return this.dataStreamNames;
        }

        public DataStreamLifecycle getDataLifecycle() {
            return this.lifecycle;
        }
    }

    static class UpdateOptionsTask
    extends AckedBatchedClusterStateUpdateTask {
        private final List<String> dataStreamNames;
        private final DataStreamOptions options;

        UpdateOptionsTask(List<String> dataStreamNames, @Nullable DataStreamOptions options, TimeValue ackTimeout, ActionListener<AcknowledgedResponse> listener) {
            super(ackTimeout, listener);
            this.dataStreamNames = dataStreamNames;
            this.options = options;
        }

        public List<String> getDataStreamNames() {
            return this.dataStreamNames;
        }

        public DataStreamOptions getOptions() {
            return this.options;
        }
    }

    static class SetRolloverOnWriteTask
    extends AckedBatchedClusterStateUpdateTask {
        private final String dataStreamName;
        private final boolean rolloverOnWrite;
        private final boolean targetFailureStore;

        SetRolloverOnWriteTask(String dataStreamName, boolean rolloverOnWrite, boolean targetFailureStore, TimeValue ackTimeout, ActionListener<AcknowledgedResponse> listener) {
            super(ackTimeout, listener);
            this.dataStreamName = dataStreamName;
            this.rolloverOnWrite = rolloverOnWrite;
            this.targetFailureStore = targetFailureStore;
        }

        public String getDataStreamName() {
            return this.dataStreamName;
        }

        public boolean rolloverOnWrite() {
            return this.rolloverOnWrite;
        }

        public boolean targetFailureStore() {
            return this.targetFailureStore;
        }
    }
}

