/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.TopDocs;
import org.elasticsearch.action.search.ArraySearchPhaseResults;
import org.elasticsearch.action.search.SearchPhaseController;
import org.elasticsearch.action.search.SearchProgressListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchShard;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.io.stream.DelayableWriteable;
import org.elasticsearch.common.lucene.search.TopDocsAndMaxScore;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.rank.context.QueryPhaseRankCoordinatorContext;

public class QueryPhaseResultConsumer
extends ArraySearchPhaseResults<SearchPhaseResult> {
    private static final Logger logger = LogManager.getLogger(QueryPhaseResultConsumer.class);
    private final Executor executor;
    private final CircuitBreaker circuitBreaker;
    private final SearchProgressListener progressListener;
    private final AggregationReduceContext.Builder aggReduceContextBuilder;
    private final QueryPhaseRankCoordinatorContext queryPhaseRankCoordinatorContext;
    private final int topNSize;
    private final boolean hasTopDocs;
    private final boolean hasAggs;
    private final boolean performFinalReduce;
    private final Consumer<Exception> onPartialMergeFailure;
    private final int batchReduceSize;
    private List<QuerySearchResult> buffer = new ArrayList<QuerySearchResult>();
    private List<SearchShard> emptyResults = new ArrayList<SearchShard>();
    private volatile long circuitBreakerBytes;
    private volatile long aggsCurrentBufferSize;
    private volatile long maxAggsCurrentBufferSize = 0L;
    private final ArrayDeque<MergeTask> queue = new ArrayDeque();
    private final AtomicReference<MergeTask> runningTask = new AtomicReference();
    private final AtomicReference<Exception> failure = new AtomicReference();
    private final SearchPhaseController.TopDocsStats topDocsStats;
    private volatile MergeResult mergeResult;
    private volatile boolean hasPartialReduce;
    private volatile int numReducePhases;
    private static final Comparator<QuerySearchResult> RESULT_COMPARATOR = Comparator.comparingInt(SearchPhaseResult::getShardIndex);

    public QueryPhaseResultConsumer(SearchRequest request, Executor executor, CircuitBreaker circuitBreaker, SearchPhaseController controller, Supplier<Boolean> isCanceled, SearchProgressListener progressListener, int expectedResultSize, Consumer<Exception> onPartialMergeFailure) {
        super(expectedResultSize);
        this.executor = executor;
        this.circuitBreaker = circuitBreaker;
        this.progressListener = progressListener;
        this.topNSize = SearchPhaseController.getTopDocsSize(request);
        this.performFinalReduce = request.isFinalReduce();
        this.onPartialMergeFailure = onPartialMergeFailure;
        SearchSourceBuilder source = request.source();
        int size = source == null || source.size() == -1 ? 10 : source.size();
        int from = source == null || source.from() == -1 ? 0 : source.from();
        this.queryPhaseRankCoordinatorContext = source == null || source.rankBuilder() == null ? null : source.rankBuilder().buildQueryPhaseCoordinatorContext(size, from);
        this.hasTopDocs = (source == null || size != 0) && this.queryPhaseRankCoordinatorContext == null;
        this.hasAggs = source != null && source.aggregations() != null;
        this.aggReduceContextBuilder = this.hasAggs ? controller.getReduceContext(isCanceled, source.aggregations()) : null;
        this.batchReduceSize = this.hasAggs || this.hasTopDocs ? Math.min(request.getBatchedReduceSize(), expectedResultSize) : expectedResultSize;
        this.topDocsStats = new SearchPhaseController.TopDocsStats(request.resolveTrackTotalHitsUpTo());
    }

    @Override
    protected synchronized void doClose() {
        assert (this.assertFailureAndBreakerConsistent());
        this.releaseBuffer();
        this.circuitBreaker.addWithoutBreaking(-this.circuitBreakerBytes);
        this.circuitBreakerBytes = 0L;
        if (this.hasPendingMerges()) {
            throw new IllegalStateException("Attempted to close with partial reduce in-flight");
        }
    }

    private boolean assertFailureAndBreakerConsistent() {
        boolean hasFailure;
        boolean bl = hasFailure = this.failure.get() != null;
        if (hasFailure ? !$assertionsDisabled && this.circuitBreakerBytes != 0L : !$assertionsDisabled && this.circuitBreakerBytes < 0L) {
            throw new AssertionError();
        }
        return true;
    }

    @Override
    public void consumeResult(SearchPhaseResult result, Runnable next) {
        super.consumeResult(result, () -> {});
        QuerySearchResult querySearchResult = result.queryResult();
        this.progressListener.notifyQueryResult(querySearchResult.getShardIndex(), querySearchResult);
        this.consume(querySearchResult, next);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchPhaseController.ReducedQueryPhase reduce() throws Exception {
        SearchPhaseController.ReducedQueryPhase reducePhase;
        ArrayList<DelayableWriteable<InternalAggregations>> aggsList;
        List<QuerySearchResult> buffer;
        if (this.hasPendingMerges()) {
            throw new AssertionError((Object)"partial reduce in-flight");
        }
        Exception f = this.failure.get();
        if (f != null) {
            throw f;
        }
        QueryPhaseResultConsumer queryPhaseResultConsumer = this;
        synchronized (queryPhaseResultConsumer) {
            buffer = this.buffer;
            buffer = buffer == null ? Collections.emptyList() : buffer;
            this.buffer = null;
        }
        buffer.sort(RESULT_COMPARATOR);
        SearchPhaseController.TopDocsStats topDocsStats = this.topDocsStats;
        MergeResult mergeResult = this.mergeResult;
        this.mergeResult = null;
        int resultSize = buffer.size() + (mergeResult == null ? 0 : 1);
        ArrayList topDocsList = this.hasTopDocs ? new ArrayList(resultSize) : null;
        ArrayList<DelayableWriteable<InternalAggregations>> arrayList = aggsList = this.hasAggs ? new ArrayList<DelayableWriteable<InternalAggregations>>(resultSize) : null;
        if (mergeResult != null) {
            if (topDocsList != null) {
                topDocsList.add(mergeResult.reducedTopDocs);
            }
            if (aggsList != null) {
                aggsList.add(DelayableWriteable.referencing(mergeResult.reducedAggs));
            }
        }
        for (QuerySearchResult result : buffer) {
            topDocsStats.add(result.topDocs(), result.searchTimedOut(), result.terminatedEarly());
            if (topDocsList != null) {
                TopDocsAndMaxScore topDocs = result.consumeTopDocs();
                SearchPhaseController.setShardIndex(topDocs.topDocs, result.getShardIndex());
                topDocsList.add(topDocs.topDocs);
            }
            if (aggsList == null) continue;
            aggsList.add(result.getAggs());
        }
        long breakerSize = this.circuitBreakerBytes;
        try {
            if (aggsList != null) {
                breakerSize = this.addEstimateAndMaybeBreak(QueryPhaseResultConsumer.estimateRamBytesUsedForReduce(breakerSize));
            }
            reducePhase = SearchPhaseController.reducedQueryPhase(this.results.asList(), aggsList, topDocsList == null ? Collections.emptyList() : topDocsList, topDocsStats, this.numReducePhases, false, this.aggReduceContextBuilder, this.queryPhaseRankCoordinatorContext, this.performFinalReduce);
        }
        finally {
            QueryPhaseResultConsumer.releaseAggs(buffer);
        }
        if (this.hasAggs && reducePhase.aggregations() != null) {
            long finalSize = DelayableWriteable.getSerializedSize(reducePhase.aggregations()) - breakerSize;
            this.addWithoutBreaking(finalSize);
            logger.trace("aggs final reduction [{}] max [{}]", (Object)this.aggsCurrentBufferSize, (Object)this.maxAggsCurrentBufferSize);
        }
        if (this.progressListener != SearchProgressListener.NOOP) {
            this.progressListener.notifyFinalReduce(SearchProgressListener.buildSearchShards(this.results.asList()), reducePhase.totalHits(), reducePhase.aggregations(), reducePhase.numReducePhases());
        }
        return reducePhase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MergeResult partialReduce(List<QuerySearchResult> toConsume, List<SearchShard> processedShards, SearchPhaseController.TopDocsStats topDocsStats, MergeResult lastMerge, int numReducePhases) {
        InternalAggregations newAggs;
        TopDocs newTopDocs;
        ArrayList<TopDocs> topDocsList;
        ArrayList<DelayableWriteable<InternalAggregations>> aggsList;
        toConsume.sort(RESULT_COMPARATOR);
        int resultSetSize = toConsume.size() + (lastMerge != null ? 1 : 0);
        if (this.hasAggs) {
            aggsList = new ArrayList<DelayableWriteable<InternalAggregations>>(resultSetSize);
            if (lastMerge != null) {
                aggsList.add(DelayableWriteable.referencing(lastMerge.reducedAggs));
            }
        } else {
            aggsList = null;
        }
        if (this.hasTopDocs) {
            topDocsList = new ArrayList<TopDocs>(resultSetSize);
            if (lastMerge != null) {
                topDocsList.add(lastMerge.reducedTopDocs);
            }
        } else {
            topDocsList = null;
        }
        try {
            for (QuerySearchResult result : toConsume) {
                topDocsStats.add(result.topDocs(), result.searchTimedOut(), result.terminatedEarly());
                SearchShardTarget target = result.getSearchShardTarget();
                processedShards.add(new SearchShard(target.getClusterAlias(), target.getShardId()));
                if (aggsList != null) {
                    aggsList.add(result.getAggs());
                }
                if (topDocsList == null) continue;
                TopDocsAndMaxScore topDocs = result.consumeTopDocs();
                SearchPhaseController.setShardIndex(topDocs.topDocs, result.getShardIndex());
                topDocsList.add(topDocs.topDocs);
            }
            newTopDocs = topDocsList == null ? null : SearchPhaseController.mergeTopDocs(topDocsList, this.topNSize, 0);
            newAggs = aggsList == null ? null : InternalAggregations.topLevelReduceDelayable(aggsList, this.aggReduceContextBuilder.forPartialReduction());
        }
        finally {
            QueryPhaseResultConsumer.releaseAggs(toConsume);
        }
        if (lastMerge != null) {
            processedShards.addAll(lastMerge.processedShards);
        }
        if (this.progressListener != SearchProgressListener.NOOP) {
            this.progressListener.notifyPartialReduce(processedShards, topDocsStats.getTotalHits(), newAggs, numReducePhases);
        }
        return new MergeResult(processedShards, newTopDocs, newAggs, newAggs != null ? DelayableWriteable.getSerializedSize(newAggs) : 0L);
    }

    public int getNumReducePhases() {
        return this.numReducePhases;
    }

    private boolean hasFailure() {
        return this.failure.get() != null;
    }

    private boolean hasPendingMerges() {
        return !this.queue.isEmpty() || this.runningTask.get() != null;
    }

    private synchronized void addWithoutBreaking(long size) {
        this.circuitBreaker.addWithoutBreaking(size);
        this.circuitBreakerBytes += size;
        this.maxAggsCurrentBufferSize = Math.max(this.maxAggsCurrentBufferSize, this.circuitBreakerBytes);
    }

    private synchronized long addEstimateAndMaybeBreak(long estimatedSize) {
        this.circuitBreaker.addEstimateBytesAndMaybeBreak(estimatedSize, "<reduce_aggs>");
        this.circuitBreakerBytes += estimatedSize;
        this.maxAggsCurrentBufferSize = Math.max(this.maxAggsCurrentBufferSize, this.circuitBreakerBytes);
        return this.circuitBreakerBytes;
    }

    private long ramBytesUsedQueryResult(QuerySearchResult result) {
        return this.hasAggs ? result.aggregations().getSerializedSize() : 0L;
    }

    private static long estimateRamBytesUsedForReduce(long size) {
        return Math.round(1.5 * (double)size - (double)size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consume(QuerySearchResult result, Runnable next) {
        if (this.hasFailure()) {
            result.consumeAll();
            next.run();
        } else if (result.isNull()) {
            result.consumeAll();
            SearchShardTarget target = result.getSearchShardTarget();
            SearchShard searchShard = new SearchShard(target.getClusterAlias(), target.getShardId());
            QueryPhaseResultConsumer queryPhaseResultConsumer = this;
            synchronized (queryPhaseResultConsumer) {
                this.emptyResults.add(searchShard);
            }
            next.run();
        } else {
            long aggsSize = this.ramBytesUsedQueryResult(result);
            boolean executeNextImmediately = true;
            boolean hasFailure = false;
            QueryPhaseResultConsumer queryPhaseResultConsumer = this;
            synchronized (queryPhaseResultConsumer) {
                if (this.hasFailure()) {
                    hasFailure = true;
                } else {
                    if (this.hasAggs) {
                        try {
                            this.addEstimateAndMaybeBreak(aggsSize);
                        }
                        catch (Exception exc) {
                            this.releaseBuffer();
                            this.onMergeFailure(exc);
                            hasFailure = true;
                        }
                    }
                    if (!hasFailure) {
                        List<QuerySearchResult> b = this.buffer;
                        this.aggsCurrentBufferSize += aggsSize;
                        int size = b.size() + (this.hasPartialReduce ? 1 : 0);
                        if (size >= this.batchReduceSize) {
                            this.hasPartialReduce = true;
                            executeNextImmediately = false;
                            MergeTask task = new MergeTask(b, this.aggsCurrentBufferSize, this.emptyResults, next);
                            b = this.buffer = new ArrayList<QuerySearchResult>();
                            this.emptyResults = new ArrayList<SearchShard>();
                            this.aggsCurrentBufferSize = 0L;
                            this.queue.add(task);
                            this.tryExecuteNext();
                        }
                        b.add(result);
                    }
                }
            }
            if (hasFailure) {
                result.consumeAll();
            }
            if (executeNextImmediately) {
                next.run();
            }
        }
    }

    private void releaseBuffer() {
        List<QuerySearchResult> b = this.buffer;
        if (b != null) {
            this.buffer = null;
            for (QuerySearchResult querySearchResult : b) {
                querySearchResult.releaseAggs();
            }
        }
    }

    private synchronized void onMergeFailure(Exception exc) {
        MergeTask mergeTask;
        if (!this.failure.compareAndSet(null, exc)) {
            assert (this.circuitBreakerBytes == 0L);
            return;
        }
        assert (this.circuitBreakerBytes >= 0L);
        if (this.circuitBreakerBytes > 0L) {
            this.circuitBreaker.addWithoutBreaking(-this.circuitBreakerBytes);
            this.circuitBreakerBytes = 0L;
        }
        this.onPartialMergeFailure.accept(exc);
        MergeTask task = this.runningTask.getAndSet(null);
        if (task != null) {
            task.cancel();
        }
        while ((mergeTask = this.queue.pollFirst()) != null) {
            mergeTask.cancel();
        }
        this.mergeResult = null;
    }

    private void tryExecuteNext() {
        assert (Thread.holdsLock(this));
        if (this.hasFailure() || this.runningTask.get() != null) {
            return;
        }
        final MergeTask task = this.queue.poll();
        this.runningTask.set(task);
        if (task == null) {
            return;
        }
        this.executor.execute(new AbstractRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void doRun() {
                MergeTask mergeTask = task;
                List<QuerySearchResult> toConsume = mergeTask.consumeBuffer();
                while (mergeTask != null) {
                    MergeResult newMerge;
                    MergeResult thisMergeResult = QueryPhaseResultConsumer.this.mergeResult;
                    long estimatedTotalSize = (thisMergeResult != null ? thisMergeResult.estimatedSize : 0L) + mergeTask.aggsBufferSize;
                    try {
                        long estimatedMergeSize = QueryPhaseResultConsumer.estimateRamBytesUsedForReduce(estimatedTotalSize);
                        QueryPhaseResultConsumer.this.addEstimateAndMaybeBreak(estimatedMergeSize);
                        estimatedTotalSize += estimatedMergeSize;
                        ++QueryPhaseResultConsumer.this.numReducePhases;
                        newMerge = QueryPhaseResultConsumer.this.partialReduce(toConsume, mergeTask.emptyResults, QueryPhaseResultConsumer.this.topDocsStats, thisMergeResult, QueryPhaseResultConsumer.this.numReducePhases);
                    }
                    catch (Exception t) {
                        QueryPhaseResultConsumer.releaseAggs(toConsume);
                        QueryPhaseResultConsumer.this.onMergeFailure(t);
                        return;
                    }
                    QueryPhaseResultConsumer t = QueryPhaseResultConsumer.this;
                    synchronized (t) {
                        if (QueryPhaseResultConsumer.this.hasFailure()) {
                            return;
                        }
                        QueryPhaseResultConsumer.this.mergeResult = newMerge;
                        if (QueryPhaseResultConsumer.this.hasAggs) {
                            long newSize = QueryPhaseResultConsumer.this.mergeResult.estimatedSize - estimatedTotalSize;
                            QueryPhaseResultConsumer.this.addWithoutBreaking(newSize);
                            if (logger.isTraceEnabled()) {
                                logger.trace("aggs partial reduction [{}->{}] max [{}]", (Object)estimatedTotalSize, (Object)QueryPhaseResultConsumer.this.mergeResult.estimatedSize, (Object)QueryPhaseResultConsumer.this.maxAggsCurrentBufferSize);
                            }
                        }
                    }
                    Runnable r = mergeTask.consumeListener();
                    QueryPhaseResultConsumer queryPhaseResultConsumer = QueryPhaseResultConsumer.this;
                    synchronized (queryPhaseResultConsumer) {
                        do {
                            mergeTask = QueryPhaseResultConsumer.this.queue.poll();
                            QueryPhaseResultConsumer.this.runningTask.set(mergeTask);
                        } while (mergeTask != null && (toConsume = mergeTask.consumeBuffer()) == null);
                    }
                    if (r == null) continue;
                    r.run();
                }
            }

            @Override
            public void onFailure(Exception exc) {
                QueryPhaseResultConsumer.this.onMergeFailure(exc);
            }
        });
    }

    private static void releaseAggs(List<QuerySearchResult> toConsume) {
        for (QuerySearchResult result : toConsume) {
            result.releaseAggs();
        }
    }

    private record MergeResult(List<SearchShard> processedShards, TopDocs reducedTopDocs, InternalAggregations reducedAggs, long estimatedSize) {
    }

    private static class MergeTask {
        private final List<SearchShard> emptyResults;
        private List<QuerySearchResult> buffer;
        private final long aggsBufferSize;
        private Runnable next;

        private MergeTask(List<QuerySearchResult> buffer, long aggsBufferSize, List<SearchShard> emptyResults, Runnable next) {
            this.buffer = buffer;
            this.aggsBufferSize = aggsBufferSize;
            this.emptyResults = emptyResults;
            this.next = next;
        }

        public synchronized List<QuerySearchResult> consumeBuffer() {
            List<QuerySearchResult> toRet = this.buffer;
            this.buffer = null;
            return toRet;
        }

        public synchronized Runnable consumeListener() {
            Runnable n = this.next;
            this.next = null;
            return n;
        }

        public void cancel() {
            Runnable next;
            List<QuerySearchResult> buffer = this.consumeBuffer();
            if (buffer != null) {
                QueryPhaseResultConsumer.releaseAggs(buffer);
            }
            if ((next = this.consumeListener()) != null) {
                next.run();
            }
        }
    }
}

