/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.datastreams.lifecycle;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.AbstractObjectParser;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class PutDataStreamLifecycleAction {
    public static final ActionType<AcknowledgedResponse> INSTANCE = new ActionType("indices:admin/data_stream/lifecycle/put");

    private PutDataStreamLifecycleAction() {
    }

    public static final class Request
    extends AcknowledgedRequest<Request>
    implements IndicesRequest.Replaceable,
    ToXContentObject {
        public static final ConstructingObjectParser<Request, Factory> PARSER = new ConstructingObjectParser<Request, Factory>("put_data_stream_lifecycle_request", false, (args, factory) -> factory.create((TimeValue)args[0], (Boolean)args[1], (DataStreamLifecycle.Downsampling)args[2]));
        private String[] names;
        private IndicesOptions indicesOptions = IndicesOptions.builder().concreteTargetOptions(IndicesOptions.ConcreteTargetOptions.ERROR_WHEN_UNAVAILABLE_TARGETS).wildcardOptions(IndicesOptions.WildcardOptions.builder().matchOpen(true).matchClosed(true).includeHidden(false).resolveAliases(false).allowEmptyExpressions(true).build()).gatekeeperOptions(IndicesOptions.GatekeeperOptions.builder().allowAliasToMultipleIndices(false).allowClosedIndices(true).ignoreThrottled(false).allowSelectors(false).build()).build();
        private final DataStreamLifecycle lifecycle;

        public static Request parseRequest(XContentParser parser, Factory factory) {
            return PARSER.apply(parser, factory);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.names = in.readStringArray();
            this.indicesOptions = IndicesOptions.readIndicesOptions(in);
            this.lifecycle = new DataStreamLifecycle(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArray(this.names);
            this.indicesOptions.writeIndicesOptions(out);
            out.writeWriteable(this.lifecycle);
        }

        public Request(TimeValue masterNodeTimeout, TimeValue ackTimeout, String[] names, @Nullable TimeValue dataRetention) {
            this(masterNodeTimeout, ackTimeout, names, dataRetention, null, null);
        }

        public Request(TimeValue masterNodeTimeout, TimeValue ackTimeout, String[] names, DataStreamLifecycle lifecycle) {
            super(masterNodeTimeout, ackTimeout);
            this.names = names;
            this.lifecycle = lifecycle;
        }

        public Request(TimeValue masterNodeTimeout, TimeValue ackTimeout, String[] names, @Nullable TimeValue dataRetention, @Nullable Boolean enabled) {
            this(masterNodeTimeout, ackTimeout, names, dataRetention, enabled, null);
        }

        public Request(TimeValue masterNodeTimeout, TimeValue ackTimeout, String[] names, @Nullable TimeValue dataRetention, @Nullable Boolean enabled, @Nullable DataStreamLifecycle.Downsampling downsampling) {
            super(masterNodeTimeout, ackTimeout);
            this.names = names;
            this.lifecycle = DataStreamLifecycle.newBuilder().dataRetention(dataRetention).enabled(enabled == null || enabled != false).downsampling(downsampling).build();
        }

        public String[] getNames() {
            return this.names;
        }

        public DataStreamLifecycle getLifecycle() {
            return this.lifecycle;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("lifecycle", this.lifecycle);
            builder.endObject();
            return builder;
        }

        @Override
        public String[] indices() {
            return this.names;
        }

        @Override
        public IndicesOptions indicesOptions() {
            return this.indicesOptions;
        }

        public Request indicesOptions(IndicesOptions indicesOptions) {
            this.indicesOptions = indicesOptions;
            return this;
        }

        @Override
        public boolean includeDataStreams() {
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Arrays.equals(this.names, request.names) && Objects.equals(this.indicesOptions, request.indicesOptions) && this.lifecycle.equals(request.lifecycle);
        }

        public int hashCode() {
            int result = Objects.hash(this.indicesOptions, this.lifecycle);
            result = 31 * result + Arrays.hashCode(this.names);
            return result;
        }

        @Override
        public IndicesRequest indices(String ... names) {
            this.names = names;
            return this;
        }

        static {
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TimeValue.parseTimeValue(p.textOrNull(), DataStreamLifecycle.DATA_RETENTION_FIELD.getPreferredName()), DataStreamLifecycle.DATA_RETENTION_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
            PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), DataStreamLifecycle.ENABLED_FIELD);
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
                if (p.currentToken() == XContentParser.Token.VALUE_NULL) {
                    return DataStreamLifecycle.Downsampling.NULL;
                }
                return new DataStreamLifecycle.Downsampling(AbstractObjectParser.parseArray(p, null, DataStreamLifecycle.Downsampling.Round::fromXContent));
            }, DataStreamLifecycle.DOWNSAMPLING_FIELD, ObjectParser.ValueType.OBJECT_ARRAY_OR_NULL);
        }

        public static interface Factory {
            public Request create(@Nullable TimeValue var1, @Nullable Boolean var2, @Nullable DataStreamLifecycle.Downsampling var3);
        }
    }
}

