/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.apache.lucene.internal.hppc.LongArrayList;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.CheckedIntConsumer;
import org.apache.lucene.search.DisiWrapper;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.DocIdStream;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.Score;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.PriorityQueue;

final class BooleanScorer
extends BulkScorer {
    static final int SHIFT = 12;
    static final int SIZE = 4096;
    static final int MASK = 4095;
    static final int SET_SIZE = 64;
    static final int SET_MASK = 63;
    final Bucket[] buckets;
    final long[] matching = new long[64];
    final DisiWrapper[] leads;
    final HeadPriorityQueue head;
    final TailPriorityQueue tail;
    final Score score = new Score();
    final int minShouldMatch;
    final long cost;
    final boolean needsScores;
    private final DocIdStreamView docIdStreamView = new DocIdStreamView();

    BooleanScorer(Collection<Scorer> scorers, int minShouldMatch, boolean needsScores) {
        if (minShouldMatch < 1 || minShouldMatch > scorers.size()) {
            throw new IllegalArgumentException("minShouldMatch should be within 1..num_scorers. Got " + minShouldMatch);
        }
        if (scorers.size() <= 1) {
            throw new IllegalArgumentException("This scorer can only be used with two scorers or more, got " + scorers.size());
        }
        if (needsScores || minShouldMatch > 1) {
            this.buckets = new Bucket[4096];
            for (int i = 0; i < this.buckets.length; ++i) {
                this.buckets[i] = new Bucket();
            }
        } else {
            this.buckets = null;
        }
        this.leads = new DisiWrapper[scorers.size()];
        this.head = new HeadPriorityQueue(scorers.size() - minShouldMatch + 1);
        this.tail = new TailPriorityQueue(minShouldMatch - 1);
        this.minShouldMatch = minShouldMatch;
        this.needsScores = needsScores;
        LongArrayList costs = new LongArrayList(scorers.size());
        for (Scorer scorer : scorers) {
            DisiWrapper w = new DisiWrapper(scorer, false);
            costs.add(w.cost);
            DisiWrapper evicted = this.tail.insertWithOverflow(w);
            if (evicted == null) continue;
            this.head.add(evicted);
        }
        this.cost = ScorerUtil.costWithMinShouldMatch(costs.stream(), costs.size(), minShouldMatch);
    }

    @Override
    public long cost() {
        return this.cost;
    }

    private void scoreDisiWrapperIntoBitSet(DisiWrapper w, Bits acceptDocs, int min, int max) throws IOException {
        boolean needsScores = this.needsScores;
        long[] matching = this.matching;
        Bucket[] buckets = this.buckets;
        DocIdSetIterator it = w.iterator;
        Scorable scorer = w.scorable;
        int doc = w.doc;
        if (doc < min) {
            doc = it.advance(min);
        }
        while (doc < max) {
            if (acceptDocs == null || acceptDocs.get(doc)) {
                int idx;
                int i = doc & 0xFFF;
                int n = idx = i >> 6;
                matching[n] = matching[n] | 1L << i;
                if (buckets != null) {
                    Bucket bucket = buckets[i];
                    ++bucket.freq;
                    if (needsScores) {
                        bucket.score += (double)scorer.score();
                    }
                }
            }
            doc = it.nextDoc();
        }
        w.doc = doc;
    }

    private void scoreWindowIntoBitSetAndReplay(LeafCollector collector, Bits acceptDocs, int base, int min, int max, DisiWrapper[] scorers, int numScorers) throws IOException {
        for (int i = 0; i < numScorers; ++i) {
            DisiWrapper w = scorers[i];
            assert (w.doc < max);
            this.scoreDisiWrapperIntoBitSet(w, acceptDocs, min, max);
        }
        this.docIdStreamView.base = base;
        collector.collect(this.docIdStreamView);
        Arrays.fill(this.matching, 0L);
    }

    private DisiWrapper advance(int min) throws IOException {
        assert (this.tail.size() == this.minShouldMatch - 1);
        HeadPriorityQueue head = this.head;
        TailPriorityQueue tail = this.tail;
        DisiWrapper headTop = (DisiWrapper)head.top();
        DisiWrapper tailTop = (DisiWrapper)tail.top();
        while (headTop.doc < min) {
            if (tailTop == null || headTop.cost <= tailTop.cost) {
                headTop.doc = headTop.iterator.advance(min);
                headTop = (DisiWrapper)head.updateTop();
                continue;
            }
            DisiWrapper previousHeadTop = headTop;
            tailTop.doc = tailTop.iterator.advance(min);
            headTop = head.updateTop(tailTop);
            tailTop = tail.updateTop(previousHeadTop);
        }
        return headTop;
    }

    private void scoreWindowMultipleScorers(LeafCollector collector, Bits acceptDocs, int windowBase, int windowMin, int windowMax, int maxFreq) throws IOException {
        while (maxFreq < this.minShouldMatch && maxFreq + this.tail.size() >= this.minShouldMatch) {
            DisiWrapper candidate = (DisiWrapper)this.tail.pop();
            if (candidate.doc < windowMin) {
                candidate.doc = candidate.iterator.advance(windowMin);
            }
            if (candidate.doc < windowMax) {
                this.leads[maxFreq++] = candidate;
                continue;
            }
            this.head.add(candidate);
        }
        if (maxFreq >= this.minShouldMatch) {
            for (int i = 0; i < this.tail.size(); ++i) {
                this.leads[maxFreq++] = this.tail.get(i);
            }
            this.tail.clear();
            this.scoreWindowIntoBitSetAndReplay(collector, acceptDocs, windowBase, windowMin, windowMax, this.leads, maxFreq);
        }
        for (int i = 0; i < maxFreq; ++i) {
            DisiWrapper evicted = this.head.insertWithOverflow(this.leads[i]);
            if (evicted == null) continue;
            this.tail.add(evicted);
        }
    }

    private void scoreWindowSingleScorer(DisiWrapper w, LeafCollector collector, Bits acceptDocs, int windowMin, int windowMax, int max) throws IOException {
        assert (this.tail.size() == 0);
        int nextWindowBase = ((DisiWrapper)this.head.top()).doc & 0xFFFFF000;
        int end = Math.max(windowMax, Math.min(max, nextWindowBase));
        DocIdSetIterator it = w.iterator;
        int doc = w.doc;
        if (doc < windowMin) {
            doc = it.advance(windowMin);
        }
        collector.setScorer(w.scorer);
        while (doc < end) {
            if (acceptDocs == null || acceptDocs.get(doc)) {
                collector.collect(doc);
            }
            doc = it.nextDoc();
        }
        w.doc = doc;
        collector.setScorer(this.score);
    }

    private DisiWrapper scoreWindow(DisiWrapper top, LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
        int windowBase = top.doc & 0xFFFFF000;
        int windowMin = Math.max(min, windowBase);
        int windowMax = Math.min(max, windowBase + 4096);
        this.leads[0] = (DisiWrapper)this.head.pop();
        int maxFreq = 1;
        while (this.head.size() > 0 && ((DisiWrapper)this.head.top()).doc < windowMax) {
            this.leads[maxFreq++] = (DisiWrapper)this.head.pop();
        }
        if (this.minShouldMatch == 1 && maxFreq == 1) {
            DisiWrapper bulkScorer = this.leads[0];
            this.scoreWindowSingleScorer(bulkScorer, collector, acceptDocs, windowMin, windowMax, max);
            return this.head.add(bulkScorer);
        }
        this.scoreWindowMultipleScorers(collector, acceptDocs, windowBase, windowMin, windowMax, maxFreq);
        return (DisiWrapper)this.head.top();
    }

    @Override
    public int score(LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
        collector.setScorer(this.score);
        DisiWrapper top = this.advance(min);
        while (top.doc < max) {
            top = this.scoreWindow(top, collector, acceptDocs, min, max);
        }
        return top.doc;
    }

    final class DocIdStreamView
    extends DocIdStream {
        int base;

        DocIdStreamView() {
        }

        @Override
        public void forEach(CheckedIntConsumer<IOException> consumer) throws IOException {
            long[] matching = BooleanScorer.this.matching;
            Bucket[] buckets = BooleanScorer.this.buckets;
            int base = this.base;
            for (int idx = 0; idx < matching.length; ++idx) {
                int ntz;
                for (long bits = matching[idx]; bits != 0L; bits ^= 1L << ntz) {
                    ntz = Long.numberOfTrailingZeros(bits);
                    if (buckets != null) {
                        int indexInWindow = idx << 6 | ntz;
                        Bucket bucket = buckets[indexInWindow];
                        if (bucket.freq >= BooleanScorer.this.minShouldMatch) {
                            BooleanScorer.this.score.score = (float)bucket.score;
                            consumer.accept(base | indexInWindow);
                        }
                        bucket.freq = 0;
                        bucket.score = 0.0;
                        continue;
                    }
                    consumer.accept(base | idx << 6 | ntz);
                }
            }
        }

        @Override
        public int count() throws IOException {
            if (BooleanScorer.this.minShouldMatch > 1) {
                return super.count();
            }
            int count = 0;
            for (long l : BooleanScorer.this.matching) {
                count += Long.bitCount(l);
            }
            return count;
        }
    }

    static class Bucket {
        double score;
        int freq;

        Bucket() {
        }
    }

    static final class HeadPriorityQueue
    extends PriorityQueue<DisiWrapper> {
        public HeadPriorityQueue(int maxSize) {
            super(maxSize);
        }

        @Override
        protected boolean lessThan(DisiWrapper a, DisiWrapper b) {
            return a.doc < b.doc;
        }
    }

    static final class TailPriorityQueue
    extends PriorityQueue<DisiWrapper> {
        public TailPriorityQueue(int maxSize) {
            super(maxSize);
        }

        @Override
        protected boolean lessThan(DisiWrapper a, DisiWrapper b) {
            return a.cost < b.cost;
        }

        public DisiWrapper get(int i) {
            Objects.checkIndex(i, this.size());
            return (DisiWrapper)this.getHeapArray()[1 + i];
        }
    }
}

