/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch.snapshot.restore.SnapshotRestore;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RestoreResponse
implements JsonpSerializable {
    @Nullable
    private final Boolean accepted;
    @Nullable
    private final SnapshotRestore snapshot;
    public static final JsonpDeserializer<RestoreResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RestoreResponse::setupRestoreResponseDeserializer);

    private RestoreResponse(Builder builder) {
        this.accepted = builder.accepted;
        this.snapshot = builder.snapshot;
    }

    public static RestoreResponse of(Function<Builder, ObjectBuilder<RestoreResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean accepted() {
        return this.accepted;
    }

    @Nullable
    public final SnapshotRestore snapshot() {
        return this.snapshot;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.accepted != null) {
            generator.writeKey("accepted");
            generator.write(this.accepted);
        }
        if (this.snapshot != null) {
            generator.writeKey("snapshot");
            this.snapshot.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRestoreResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::accepted, JsonpDeserializer.booleanDeserializer(), "accepted");
        op.add(Builder::snapshot, SnapshotRestore._DESERIALIZER, "snapshot");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RestoreResponse> {
        @Nullable
        private Boolean accepted;
        @Nullable
        private SnapshotRestore snapshot;

        public final Builder accepted(@Nullable Boolean value) {
            this.accepted = value;
            return this;
        }

        public final Builder snapshot(@Nullable SnapshotRestore value) {
            this.snapshot = value;
            return this;
        }

        public final Builder snapshot(Function<SnapshotRestore.Builder, ObjectBuilder<SnapshotRestore>> fn) {
            return this.snapshot(fn.apply(new SnapshotRestore.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RestoreResponse build() {
            this._checkSingleUse();
            return new RestoreResponse(this);
        }
    }
}

