/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch.indices.StorageType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Storage
implements JsonpSerializable {
    private final String type;
    @Nullable
    private final Boolean allowMmap;
    public static final JsonpDeserializer<Storage> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Storage::setupStorageDeserializer);

    private Storage(Builder builder) {
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
        this.allowMmap = builder.allowMmap;
    }

    public static Storage of(Function<Builder, ObjectBuilder<Storage>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String type() {
        return this.type;
    }

    @Nullable
    public final Boolean allowMmap() {
        return this.allowMmap;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("type");
        generator.write(this.type);
        if (this.allowMmap != null) {
            generator.writeKey("allow_mmap");
            generator.write(this.allowMmap);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupStorageDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
        op.add(Builder::allowMmap, JsonpDeserializer.booleanDeserializer(), "allow_mmap");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Storage> {
        private String type;
        @Nullable
        private Boolean allowMmap;

        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        public final Builder type(StorageType value) {
            this.type = value == null ? null : value.jsonValue();
            return this;
        }

        public final Builder allowMmap(@Nullable Boolean value) {
            this.allowMmap = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Storage build() {
            this._checkSingleUse();
            return new Storage(this);
        }
    }
}

