"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeoUploadWizardAsyncWrapper = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _lazy_load_bundle = require("../lazy_load_bundle");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class GeoUploadWizardAsyncWrapper extends _react.default.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      GeoUploadWizard: null
    });
    (0, _defineProperty2.default)(this, "_isMounted", false);
  }
  componentDidMount() {
    this._isMounted = true;
    (0, _lazy_load_bundle.lazyLoadModules)().then(modules => {
      if (this._isMounted) {
        this.setState({
          GeoUploadWizard: modules.GeoUploadWizard
        });
      }
    });
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  render() {
    const {
      GeoUploadWizard
    } = this.state;
    return GeoUploadWizard ? /*#__PURE__*/_react.default.createElement(GeoUploadWizard, this.props) : /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 3
    });
  }
}
exports.GeoUploadWizardAsyncWrapper = GeoUploadWizardAsyncWrapper;