"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricComponent = void 0;
var _react = _interopRequireDefault(require("react"));
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const MetricComponent = ({
  label,
  metric,
  labelFont,
  metricFont,
  metricFormat
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasMetric"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasMetric__metric",
    style: metricFont
  }, metricFormat ? (0, _numeral.default)(metric).format(metricFormat) : metric), label && /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasMetric__label",
    style: labelFont
  }, label));
};
exports.MetricComponent = MetricComponent;