"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataHandler = getDataHandler;
exports.registerDataHandler = registerDataHandler;
exports.unregisterDataHandler = unregisterDataHandler;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const dataHandlers = {};
function registerDataHandler({
  appName,
  fetchData,
  hasData
}) {
  dataHandlers[appName] = {
    fetchData,
    hasData
  };
}
function unregisterDataHandler({
  appName
}) {
  delete dataHandlers[appName];
}
function getDataHandler(appName) {
  const dataHandler = dataHandlers[appName];
  if (dataHandler) {
    return dataHandler;
  }
}