"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SingleMetricLensAttributes = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _single_metric_config = require("../synthetics/single_metric_config");
var _constants = require("../constants");
var _lens_attributes = require("../lens_attributes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SingleMetricLensAttributes extends _lens_attributes.LensAttributes {
  constructor(layerConfigs, reportType, lensFormulaHelper, dslFilters) {
    super(layerConfigs, reportType, lensFormulaHelper, dslFilters);
    (0, _defineProperty2.default)(this, "columnId", void 0);
    (0, _defineProperty2.default)(this, "metricStateOptions", void 0);
    this.layers = {};
    this.reportType = reportType;
    this.layerConfigs = layerConfigs;
    this.isMultiSeries = layerConfigs.length > 1;
    this.columnId = 'layer-0-column-1';
    this.globalFilter = this.getGlobalFilter(this.isMultiSeries);
    const layer0 = this.getSingleMetricLayer();
    this.layers = {
      layer0
    };
    this.visualization = this.getMetricState();
  }
  getSingleMetricLayer() {
    const {
      seriesConfig,
      selectedMetricField,
      operationType,
      dataView,
      name
    } = this.layerConfigs[0];
    const metricOption = (0, _lens_attributes.parseCustomFieldName)(seriesConfig, selectedMetricField);
    if (!Array.isArray(metricOption)) {
      const {
        columnFilter,
        columnField,
        columnLabel,
        columnType,
        formula,
        metricStateOptions,
        format,
        emptyAsNull = true
      } = metricOption;
      this.metricStateOptions = metricStateOptions;
      if (columnType === _constants.FORMULA_COLUMN && formula) {
        return this.getFormulaLayer({
          formula,
          label: name !== null && name !== void 0 ? name : columnLabel,
          dataView,
          format,
          filter: columnFilter
        });
      }
      const getSourceField = () => {
        if (selectedMetricField.startsWith('Records') || selectedMetricField.startsWith('records')) {
          return 'Records';
        }
        return columnField || selectedMetricField;
      };
      const sourceField = getSourceField();
      const isPercentileColumn = operationType === null || operationType === void 0 ? void 0 : operationType.includes('th');
      if (isPercentileColumn) {
        return this.getPercentileLayer({
          sourceField,
          operationType,
          seriesConfig,
          columnLabel,
          columnFilter
        });
      }
      return {
        columns: {
          [this.columnId]: {
            ...(0, _lens_attributes.buildNumberColumn)(sourceField),
            customLabel: true,
            label: name !== null && name !== void 0 ? name : columnLabel,
            operationType: sourceField === _constants.RECORDS_FIELD ? 'count' : operationType || 'median',
            filter: columnFilter,
            params: {
              emptyAsNull
            }
          }
        },
        columnOrder: [this.columnId],
        incompleteColumns: {}
      };
    }
  }
  getFormulaLayer({
    formula,
    label,
    dataView,
    format,
    filter
  }) {
    var _this$lensFormulaHelp;
    const layer = (_this$lensFormulaHelp = this.lensFormulaHelper) === null || _this$lensFormulaHelp === void 0 ? void 0 : _this$lensFormulaHelp.insertOrReplaceFormulaColumn(this.columnId, {
      formula,
      label,
      filter,
      format: format === 'percent' || !format ? {
        id: 'percent',
        params: {
          decimals: 3
        }
      } : undefined
    }, {
      columns: {},
      columnOrder: []
    }, dataView);
    return layer;
  }
  getPercentileLayer({
    sourceField,
    operationType,
    seriesConfig,
    columnLabel,
    columnFilter
  }) {
    return {
      columns: {
        [this.columnId]: {
          ...this.getPercentileNumberColumn(sourceField, operationType, seriesConfig),
          label: columnLabel !== null && columnLabel !== void 0 ? columnLabel : '',
          filter: columnFilter,
          customLabel: true
        }
      },
      columnOrder: [this.columnId],
      incompleteColumns: {}
    };
  }
  getMetricState() {
    var _this$metricStateOpti;
    const {
      color
    } = this.layerConfigs[0];
    const metricStateOptions = {
      ...((_this$metricStateOpti = this.metricStateOptions) !== null && _this$metricStateOpti !== void 0 ? _this$metricStateOpti : {}),
      ...(color ? {
        colorMode: 'Labels',
        palette: (0, _single_metric_config.getColorPalette)(color)
      } : {})
    };
    return {
      accessor: this.columnId,
      layerId: 'layer0',
      layerType: 'data',
      ...metricStateOptions,
      size: 's'
    };
  }
}
exports.SingleMetricLensAttributes = SingleMetricLensAttributes;