"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsqlVariablesService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class EsqlVariablesService {
  constructor() {
    (0, _defineProperty2.default)(this, "esqlVariables", []);
    (0, _defineProperty2.default)(this, "areSuggestionsEnabled", false);
  }
  enableSuggestions() {
    this.areSuggestionsEnabled = true;
  }
  disableSuggestions() {
    this.areSuggestionsEnabled = false;
  }
  addVariable(variable) {
    const variables = [...this.esqlVariables];
    const variableExists = variables.find(v => v.key === variable.key);
    if (variableExists) {
      return;
    }
    variables.push({
      ...variable,
      value: Number.isNaN(Number(variable.value)) ? variable.value : Number(variable.value)
    });
    this.esqlVariables = variables;
  }
  clearVariables() {
    this.esqlVariables = [];
  }
}
exports.EsqlVariablesService = EsqlVariablesService;