"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.searchByTypeRt = exports.searchBySourcesRt = exports.entityTypeDefinitionRt = exports.entitySourceDefinitionRt = exports.countByTypesRt = void 0;
var _zod = require("@kbn/zod");
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Definitions

const entityTypeDefinitionRt = exports.entityTypeDefinitionRt = _zod.z.object({
  id: _zod.z.string(),
  display_name: _zod.z.string()
});
const entitySourceDefinitionRt = exports.entitySourceDefinitionRt = _zod.z.object({
  id: _zod.z.string(),
  type_id: _zod.z.string(),
  index_patterns: _zod.z.array(_zod.z.string()),
  identity_fields: _zod.z.array(_zod.z.string()),
  metadata_fields: _zod.z.array(_zod.z.string()),
  filters: _zod.z.array(_zod.z.string()),
  timestamp_field: _zod.z.optional(_zod.z.string()),
  display_name: _zod.z.optional(_zod.z.string())
});

// Stored definitions

// API parameters

const sortByRt = _zod.z.object({
  field: _zod.z.string(),
  direction: _zod.z.enum(['ASC', 'DESC'])
});
const searchCommonRt = _zod.z.object({
  start: _zod.z.optional(_zod.z.string()).default(() => (0, _moment.default)().subtract(5, 'minutes').toISOString()).refine(val => (0, _moment.default)(val).isValid(), {
    message: '[start] should be a date in ISO format'
  }),
  end: _zod.z.optional(_zod.z.string()).default(() => (0, _moment.default)().toISOString()).refine(val => (0, _moment.default)(val).isValid(), {
    message: '[end] should be a date in ISO format'
  }),
  sort: _zod.z.optional(sortByRt),
  limit: _zod.z.optional(_zod.z.number()).default(10),
  metadata_fields: _zod.z.optional(_zod.z.array(_zod.z.string())).default([]),
  filters: _zod.z.optional(_zod.z.array(_zod.z.string())).default([])
});
const searchByTypeRt = exports.searchByTypeRt = _zod.z.intersection(searchCommonRt, _zod.z.object({
  type: _zod.z.string()
}));
const searchBySourcesRt = exports.searchBySourcesRt = _zod.z.intersection(searchCommonRt, _zod.z.object({
  sources: _zod.z.array(entitySourceDefinitionRt)
}));
const countByTypesRt = exports.countByTypesRt = _zod.z.object({
  types: _zod.z.optional(_zod.z.array(_zod.z.string())),
  filters: _zod.z.optional(_zod.z.array(_zod.z.string())),
  start: _zod.z.optional(_zod.z.string()).default(() => (0, _moment.default)().subtract(5, 'minutes').toISOString()).refine(val => (0, _moment.default)(val).isValid(), {
    message: '[start] should be a date in ISO format'
  }),
  end: _zod.z.optional(_zod.z.string()).default(() => (0, _moment.default)().toISOString()).refine(val => (0, _moment.default)(val).isValid(), {
    message: '[end] should be a date in ISO format'
  })
});