"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateConfig = void 0;
var _searchConnectors = require("@kbn/search-connectors");
var _create_index = require("../indices/create_index");
var _exists_index = require("../indices/exists_index");
var _generate_api_key = require("../indices/generate_api_key");
var _generate_index_name = require("../indices/generate_index_name");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generateConfig = async (client, connector) => {
  let associatedIndex;
  if (connector.index_name) {
    associatedIndex = connector.index_name;
  } else {
    const indexPrefix = connector.is_native ? _searchConnectors.MANAGED_CONNECTOR_INDEX_PREFIX : ''; // managed connectors need to be prefixed with `content-`
    const connectorReference = connector.name || connector.service_type || 'my-connector'; // pass a default name to generate a readable index name rather than gibberish

    associatedIndex = await (0, _generate_index_name.generatedIndexName)(client, indexPrefix + connectorReference);
  }
  if (!(0, _exists_index.indexOrAliasExists)(client, associatedIndex)) {
    await (0, _create_index.createIndex)(client, associatedIndex, connector.language, true);
  }
  await client.asCurrentUser.transport.request({
    body: {
      index_name: associatedIndex
    },
    method: 'PUT',
    path: `/_connector/${connector.id}/_index_name`
  });
  await client.asCurrentUser.indices.refresh({
    index: _searchConnectors.CONNECTORS_INDEX
  });
  const apiKeyResponse = await (0, _generate_api_key.generateApiKey)(client, associatedIndex, connector.is_native);
  return {
    apiKeyResponse,
    associatedIndex
  };
};
exports.generateConfig = generateConfig;