"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateConnector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _unsavedChangesPrompt = require("@kbn/unsaved-changes-prompt");
var _error_to_text = require("../../../../../../common/utils/error_to_text");
var _http = require("../../../../shared/http");
var _kibana = require("../../../../shared/kibana");
var _add_connector_api_logic = require("../../../api/connector/add_connector_api_logic");
var _layout = require("../../layout");
var _new_connector_logic = require("../../new_index/method_connector/new_connector_logic");
var _connectors = require("../connectors");
var _generate_step_state = require("../utils/generate_step_state");
var _connector_logos_comp = _interopRequireDefault(require("./assets/connector_logos_comp.png"));
var _configuration_step = require("./configuration_step");
var _deployment_step = require("./deployment_step");
var _finish_up_step = require("./finish_up_step");
var _start_step = require("./start_step");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateConnector = () => {
  var _overlays$openConfirm, _selectedConnector$ic;
  const {
    overlays
  } = (0, _public.useKibana)().services;
  const {
    http
  } = (0, _kea.useValues)(_http.HttpLogic);
  const {
    application,
    history
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    error
  } = (0, _kea.useValues)(_add_connector_api_logic.AddConnectorApiLogic);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [selfManagePreference, setSelfManagePreference] = (0, _react.useState)('selfManaged');
  const {
    selectedConnector,
    currentStep,
    isFormDirty
  } = (0, _kea.useValues)(_new_connector_logic.NewConnectorLogic);
  const {
    setCurrentStep
  } = (0, _kea.useActions)(_new_connector_logic.NewConnectorLogic);
  const stepStates = (0, _generate_step_state.generateStepState)(currentStep);
  const getSteps = selfManaged => {
    return [{
      children: null,
      status: stepStates.start,
      title: _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.startStep.startLabel', {
        defaultMessage: 'Start'
      })
    }, ...(selfManaged ? [{
      children: null,
      status: stepStates.deployment,
      title: _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.deploymentStep.deploymentLabel', {
        defaultMessage: 'Deployment'
      })
    }] : []), {
      children: null,
      status: stepStates.configure,
      title: _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.configurationStep.configurationLabel', {
        defaultMessage: 'Configuration'
      })
    }, {
      children: null,
      status: stepStates.finish,
      title: _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.finishUpStep.finishUpLabel', {
        defaultMessage: 'Finish up'
      })
    }];
  };
  const stepContent = {
    configure: /*#__PURE__*/_react.default.createElement(_configuration_step.ConfigurationStep, {
      title: _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.configurationStep.configurationLabel', {
        defaultMessage: 'Configuration'
      }),
      setCurrentStep: setCurrentStep
    }),
    deployment: /*#__PURE__*/_react.default.createElement(_deployment_step.DeploymentStep, {
      setCurrentStep: setCurrentStep
    }),
    finish: /*#__PURE__*/_react.default.createElement(_finish_up_step.FinishUpStep, {
      title: _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.finishUpStep.finishUpLabel', {
        defaultMessage: 'Finish up'
      })
    }),
    start: /*#__PURE__*/_react.default.createElement(_start_step.StartStep, {
      title: _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.startStep.startLabel', {
        defaultMessage: 'Start'
      }),
      selfManagePreference: selfManagePreference,
      setCurrentStep: setCurrentStep,
      onSelfManagePreferenceChange: preference => {
        setSelfManagePreference(preference);
      },
      error: (0, _error_to_text.errorToText)(error)
    })
  };
  (0, _unsavedChangesPrompt.useUnsavedChangesPrompt)({
    cancelButtonText: _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.unsavedPrompt.cancel', {
      defaultMessage: 'Continue setup'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.unsavedPrompt.confirm', {
      defaultMessage: 'Leave the page'
    }),
    hasUnsavedChanges: isFormDirty,
    history,
    http,
    messageText: _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.unsavedPrompt.body', {
      defaultMessage: 'Your connector is created but missing some details. You can complete the setup later in the connector configuration page, but this guided flow offers more help.'
    }),
    navigateToUrl: application.navigateToUrl,
    openConfirm: (_overlays$openConfirm = overlays === null || overlays === void 0 ? void 0 : overlays.openConfirm) !== null && _overlays$openConfirm !== void 0 ? _overlays$openConfirm : () => Promise.resolve(false),
    titleText: _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.unsavedPrompt.title', {
      defaultMessage: 'Your connector is not fully configured'
    })
  });
  return /*#__PURE__*/_react.default.createElement(_layout.EnterpriseSearchContentPageTemplate, {
    pageChrome: [..._connectors.connectorsBreadcrumbs, _i18n.i18n.translate('xpack.enterpriseSearch.createConnector..breadcrumb', {
      defaultMessage: 'New connector'
    })],
    pageViewTelemetry: "create_connector",
    isLoading: false,
    pageHeader: {
      description: _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.description', {
        defaultMessage: 'Extract, transform, index and sync data from a third-party data source.'
      }),
      pageTitle: _i18n.i18n.translate('xpack.enterpriseSearch.createConnector..title', {
        defaultMessage: 'Create a connector'
      })
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    color: "subdued",
    paddingSize: "l",
    css: (0, _react2.css)`
              ${currentStep === 'start' ? `background-image: url(${_connector_logos_comp.default});` : ''}
              background-size: contain;
              background-repeat: no-repeat;
              background-position: bottom center;
              min-height: 466px;
              border: 1px solid ${euiTheme.colors.lightShade};
            `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    titleSize: "xxs",
    steps: getSteps(selfManagePreference === 'selfManaged'),
    css: () => (0, _react2.css)`
                .euiStep__content {
                  padding-block-end: ${euiTheme.size.xs};
                }
              `
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), (selectedConnector === null || selectedConnector === void 0 ? void 0 : selectedConnector.docsUrl) && (selectedConnector === null || selectedConnector === void 0 ? void 0 : selectedConnector.docsUrl) !== '' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    external: true,
    "data-test-subj": "enterpriseSearchCreateConnectorConnectorDocsLink",
    href: selectedConnector === null || selectedConnector === void 0 ? void 0 : selectedConnector.docsUrl,
    target: "_blank"
  }, 'Elastic ', selectedConnector === null || selectedConnector === void 0 ? void 0 : selectedConnector.name, _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.connectorDocsLinkLabel', {
    defaultMessage: ' connector reference'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), currentStep !== 'start' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.euiFormRow.connectorLabel', {
      defaultMessage: 'Connector'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    readOnly: true,
    valueOfSelected: "item1",
    options: [{
      inputDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "l",
        type: (_selectedConnector$ic = selectedConnector === null || selectedConnector === void 0 ? void 0 : selectedConnector.iconPath) !== null && _selectedConnector$ic !== void 0 ? _selectedConnector$ic : '',
        css: (0, _react2.css)`
                                margin-right: ${euiTheme.size.m};
                              `
      }), selectedConnector === null || selectedConnector === void 0 ? void 0 : selectedConnector.name),
      value: 'item1'
    }]
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, selfManagePreference === 'selfManaged' ? _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.badgeType.selfManaged', {
    defaultMessage: 'Self-managed'
  }) : _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.badgeType.ElasticManaged', {
    defaultMessage: 'Elastic managed'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7
  }, stepContent[currentStep])));
};
exports.CreateConnector = CreateConnector;