"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrawlersRouter = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _routes = require("../../routes");
var _connectors = require("./connectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CrawlersRouter = () => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    exact: true,
    path: _routes.CRAWLERS_NEW_PATH,
    to: _routes.CRAWLERS_PATH
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.CRAWLERS_PATH
  }, /*#__PURE__*/_react.default.createElement(_connectors.Connectors, {
    isCrawler: true,
    isCrawlerSelfManaged: true
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.CRAWLERS_ELASTIC_MANAGED_PATH
  }, /*#__PURE__*/_react.default.createElement(_connectors.Connectors, {
    isCrawler: true,
    isCrawlerSelfManaged: false
  })));
};
exports.CrawlersRouter = CrawlersRouter;