"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchApplicationConnect = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _i18n = require("@kbn/i18n");
var _encode_path_params = require("../../../../shared/encode_path_params");
var _kibana = require("../../../../shared/kibana");
var _routes = require("../../../routes");
var _page_template = require("../../layout/page_template");
var _search_application_view_logic = require("../search_application_view_logic");
var _search_application_api = require("./search_application_api");
require("../search_application_layout.scss");
var _search_application_documentation = require("./search_application_documentation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const pageTitle = _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.connect.pageTitle', {
  defaultMessage: 'Connect'
});
const SAFE_SEARCH_API_TAB_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.connect.searchAPITabTitle', {
  defaultMessage: 'Search API'
});
const DOCUMENTATION_TAB_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.connect.documentationTabTitle', {
  defaultMessage: 'Documentation'
});
const getTabBreadCrumb = tabId => {
  switch (tabId) {
    case _routes.SearchApplicationConnectTabs.SEARCHAPI:
      return SAFE_SEARCH_API_TAB_TITLE;
    case _routes.SearchApplicationConnectTabs.DOCUMENTATION:
      return DOCUMENTATION_TAB_TITLE;
    default:
      return tabId;
  }
};
const SearchApplicationConnect = () => {
  const {
    searchApplicationName,
    isLoadingSearchApplication,
    hasSchemaConflicts
  } = (0, _kea.useValues)(_search_application_view_logic.SearchApplicationViewLogic);
  const {
    connectTabId = _routes.SearchApplicationConnectTabs.SEARCHAPI
  } = (0, _reactRouterDom.useParams)();
  const onTabClick = tab => () => {
    _kibana.KibanaLogic.values.navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_APPLICATION_CONNECT_PATH, {
      connectTabId: tab,
      searchApplicationName
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_page_template.EnterpriseSearchApplicationsPageTemplate, {
    pageChrome: [searchApplicationName, pageTitle, getTabBreadCrumb(connectTabId)],
    pageViewTelemetry: _routes.SearchApplicationViewTabs.CONNECT,
    isLoading: isLoadingSearchApplication,
    pageHeader: {
      bottomBorder: false,
      className: 'searchApplicationHeaderBackgroundColor',
      pageTitle,
      rightSideItems: [],
      tabs: [{
        isSelected: connectTabId === _routes.SearchApplicationConnectTabs.SEARCHAPI,
        label: SAFE_SEARCH_API_TAB_TITLE,
        onClick: onTabClick(_routes.SearchApplicationConnectTabs.SEARCHAPI)
      }, {
        isSelected: connectTabId === _routes.SearchApplicationConnectTabs.DOCUMENTATION,
        label: DOCUMENTATION_TAB_TITLE,
        onClick: onTabClick(_routes.SearchApplicationConnectTabs.DOCUMENTATION)
      }]
    },
    searchApplicationName: searchApplicationName,
    hasSchemaConflicts: hasSchemaConflicts
  }, connectTabId === _routes.SearchApplicationConnectTabs.SEARCHAPI && /*#__PURE__*/_react.default.createElement(_search_application_api.SearchApplicationAPI, null), connectTabId === _routes.SearchApplicationConnectTabs.DOCUMENTATION && /*#__PURE__*/_react.default.createElement(_search_application_documentation.SearchApplicationDocumentation, null));
};
exports.SearchApplicationConnect = SearchApplicationConnect;