"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.chatCompleteRoute = exports.SYSTEM_PROMPT_CONTEXT_NON_I18N = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _common = require("@kbn/elastic-assistant-common/impl/schemas/common");
var _server = require("@kbn/data-plugin/server");
var _event_based_telemetry = require("../../lib/telemetry/event_based_telemetry");
var _build_response = require("../../lib/build_response");
var _helpers = require("../helpers");
var _helpers2 = require("../../ai_assistant_data_clients/anonymization_fields/helpers");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SYSTEM_PROMPT_CONTEXT_NON_I18N = context => {
  return `CONTEXT:\n"""\n${context}\n"""`;
};
exports.SYSTEM_PROMPT_CONTEXT_NON_I18N = SYSTEM_PROMPT_CONTEXT_NON_I18N;
const chatCompleteRoute = (router, config) => {
  const RESPONSE_TIMEOUT = config === null || config === void 0 ? void 0 : config.responseTimeout;
  router.versioned.post({
    access: 'public',
    path: _elasticAssistantCommon.ELASTIC_AI_ASSISTANT_CHAT_COMPLETE_URL,
    security: {
      authz: {
        requiredPrivileges: ['elasticAssistant']
      }
    },
    options: {
      timeout: {
        // Add extra time to the timeout to account for the time it takes to process the request
        idleSocket: RESPONSE_TIMEOUT + 30 * 1000
      }
    }
  }).addVersion({
    version: _elasticAssistantCommon.API_VERSIONS.public.v1,
    validate: {
      request: {
        body: (0, _common.buildRouteValidationWithZod)(_elasticAssistantCommon.ChatCompleteProps)
      }
    }
  }, async (context, request, response) => {
    const abortSignal = (0, _server.getRequestAbortedSignal)(request.events.aborted$);
    const assistantResponse = (0, _build_response.buildResponse)(response);
    let telemetry;
    let actionTypeId;
    const ctx = await context.resolve(['core', 'elasticAssistant', 'licensing']);
    const logger = ctx.elasticAssistant.logger;
    try {
      var _await$ctx$elasticAss, _connector$actionType, _newConversation2, _request$body$isStrea, _messages;
      telemetry = ctx.elasticAssistant.telemetry;
      const inference = ctx.elasticAssistant.inference;
      const productDocsAvailable = (_await$ctx$elasticAss = await ctx.elasticAssistant.llmTasks.retrieveDocumentationAvailable()) !== null && _await$ctx$elasticAss !== void 0 ? _await$ctx$elasticAss : false;

      // Perform license and authenticated user checks
      const checkResponse = await (0, _helpers.performChecks)({
        context: ctx,
        request,
        response
      });
      if (!checkResponse.isSuccess) {
        return checkResponse.response;
      }
      const conversationsDataClient = await ctx.elasticAssistant.getAIAssistantConversationsDataClient();
      const anonymizationFieldsDataClient = await ctx.elasticAssistant.getAIAssistantAnonymizationFieldsDataClient();
      let messages;
      const existingConversationId = request.body.conversationId;
      const connectorId = request.body.connectorId;
      let latestReplacements = {};
      const onNewReplacements = newReplacements => {
        latestReplacements = {
          ...latestReplacements,
          ...newReplacements
        };
      };

      // get the actions plugin start contract from the request context:
      const actions = ctx.elasticAssistant.actions;
      const actionsClient = await actions.getActionsClientWithRequest(request);
      const connectors = await actionsClient.getBulk({
        ids: [connectorId]
      });
      const connector = connectors.length > 0 ? connectors[0] : undefined;
      actionTypeId = (_connector$actionType = connector === null || connector === void 0 ? void 0 : connector.actionTypeId) !== null && _connector$actionType !== void 0 ? _connector$actionType : '.gen-ai';
      const isOssModel = (0, _utils.isOpenSourceModel)(connector);
      const savedObjectsClient = ctx.elasticAssistant.savedObjectsClient;

      // replacements
      const anonymizationFieldsRes = await (anonymizationFieldsDataClient === null || anonymizationFieldsDataClient === void 0 ? void 0 : anonymizationFieldsDataClient.findDocuments({
        perPage: 1000,
        page: 1
      }));
      let anonymizationFields = anonymizationFieldsRes ? (0, _helpers2.transformESSearchToAnonymizationFields)(anonymizationFieldsRes.data) : undefined;

      // anonymize messages before sending to LLM
      messages = request.body.messages.map(m => {
        var _m$content;
        let content = (_m$content = m.content) !== null && _m$content !== void 0 ? _m$content : '';
        if (m.data) {
          // includes/anonymize fields from the messages data
          if (m.fields_to_anonymize && m.fields_to_anonymize.length > 0) {
            var _anonymizationFields;
            anonymizationFields = (_anonymizationFields = anonymizationFields) === null || _anonymizationFields === void 0 ? void 0 : _anonymizationFields.map(a => {
              var _m$fields_to_anonymiz;
              if ((_m$fields_to_anonymiz = m.fields_to_anonymize) !== null && _m$fields_to_anonymiz !== void 0 && _m$fields_to_anonymiz.includes(a.field)) {
                return {
                  ...a,
                  allowed: true,
                  anonymized: true
                };
              }
              return a;
            });
          }
          const anonymizedData = (0, _elasticAssistantCommon.transformRawData)({
            anonymizationFields,
            currentReplacements: latestReplacements,
            getAnonymizedValue: _elasticAssistantCommon.getAnonymizedValue,
            onNewReplacements,
            rawData: Object.keys(m.data).reduce((obj, key) => ({
              ...obj,
              [key]: [m.data ? m.data[key] : '']
            }), {})
          });
          const wr = `${SYSTEM_PROMPT_CONTEXT_NON_I18N(anonymizedData)}\n`;
          content = `${wr}\n${m.content}`;
        }
        const transformedMessage = {
          role: m.role,
          content
        };
        return transformedMessage;
      });
      let newConversation;
      if (conversationsDataClient && !existingConversationId && request.body.persist) {
        var _newConversation, _newConversation$mess;
        newConversation = await (0, _helpers.createConversationWithUserInput)({
          actionTypeId,
          connectorId,
          conversationsDataClient,
          promptId: request.body.promptId,
          replacements: latestReplacements,
          newMessages: messages,
          model: request.body.model
        });

        // messages are anonymized by conversationsDataClient
        messages = (_newConversation = newConversation) === null || _newConversation === void 0 ? void 0 : (_newConversation$mess = _newConversation.messages) === null || _newConversation$mess === void 0 ? void 0 : _newConversation$mess.map(c => ({
          role: c.role,
          content: c.content
        }));
      }
      const timeout = new Promise((_, reject) => {
        setTimeout(() => {
          reject(new Error('Request timed out, increase xpack.elasticAssistant.responseTimeout'));
        }, config === null || config === void 0 ? void 0 : config.responseTimeout);
      });

      // Do not persist conversation messages if `persist = false`
      const conversationId = request.body.persist ? existingConversationId !== null && existingConversationId !== void 0 ? existingConversationId : (_newConversation2 = newConversation) === null || _newConversation2 === void 0 ? void 0 : _newConversation2.id : undefined;
      const contentReferencesStore = (0, _elasticAssistantCommon.newContentReferencesStore)();
      const onLlmResponse = async (content, traceData = {}, isError = false) => {
        if (conversationId && conversationsDataClient) {
          const contentReferences = (0, _elasticAssistantCommon.pruneContentReferences)(content, contentReferencesStore);
          await (0, _helpers.appendAssistantMessageToConversation)({
            conversationId,
            conversationsDataClient,
            messageContent: content,
            replacements: latestReplacements,
            isError,
            traceData,
            contentReferences
          });
        }
      };
      return await Promise.race([(0, _helpers.langChainExecute)({
        abortSignal,
        isStream: (_request$body$isStrea = request.body.isStream) !== null && _request$body$isStrea !== void 0 ? _request$body$isStrea : false,
        actionsClient,
        actionTypeId,
        connectorId,
        isOssModel,
        conversationId,
        context: ctx,
        logger,
        inference,
        messages: (_messages = messages) !== null && _messages !== void 0 ? _messages : [],
        onLlmResponse,
        onNewReplacements,
        replacements: latestReplacements,
        contentReferencesStore,
        request: {
          ...request,
          // TODO: clean up after empty tools will be available to use
          body: {
            ...request.body,
            replacements: {},
            size: 10,
            alertsIndexPattern: '.alerts-security.alerts-default'
          }
        },
        response,
        telemetry,
        responseLanguage: request.body.responseLanguage,
        savedObjectsClient,
        ...(productDocsAvailable ? {
          llmTasks: ctx.elasticAssistant.llmTasks
        } : {})
      }), timeout]);
    } catch (err) {
      var _await$ctx$elasticAss2, _telemetry, _actionTypeId, _request$body$isStrea2;
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      const kbDataClient = (_await$ctx$elasticAss2 = await ctx.elasticAssistant.getAIAssistantKnowledgeBaseDataClient()) !== null && _await$ctx$elasticAss2 !== void 0 ? _await$ctx$elasticAss2 : undefined;
      const isKnowledgeBaseInstalled = await (0, _helpers.getIsKnowledgeBaseInstalled)(kbDataClient);
      (_telemetry = telemetry) === null || _telemetry === void 0 ? void 0 : _telemetry.reportEvent(_event_based_telemetry.INVOKE_ASSISTANT_ERROR_EVENT.eventType, {
        actionTypeId: (_actionTypeId = actionTypeId) !== null && _actionTypeId !== void 0 ? _actionTypeId : '',
        model: request.body.model,
        errorMessage: error.message,
        assistantStreamingEnabled: (_request$body$isStrea2 = request.body.isStream) !== null && _request$body$isStrea2 !== void 0 ? _request$body$isStrea2 : false,
        isEnabledKnowledgeBase: isKnowledgeBaseInstalled,
        errorLocation: 'chatCompleteRoute'
      });
      return assistantResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.chatCompleteRoute = chatCompleteRoute;