"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogsContextService = exports.createLogsContextService = exports.DEFAULT_ALLOWED_LOGS_BASE_PATTERNS_REGEXP = exports.DEFAULT_ALLOWED_LOGS_BASE_PATTERNS = void 0;
var _dataViewUtils = require("@kbn/data-view-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DEFAULT_ALLOWED_LOGS_BASE_PATTERNS = exports.DEFAULT_ALLOWED_LOGS_BASE_PATTERNS = ['log', 'logs', 'logstash', 'auditbeat', 'filebeat', 'winlogbeat'];
const DEFAULT_ALLOWED_LOGS_BASE_PATTERNS_REGEXP = exports.DEFAULT_ALLOWED_LOGS_BASE_PATTERNS_REGEXP = (0, _dataViewUtils.createRegExpPatternFrom)(DEFAULT_ALLOWED_LOGS_BASE_PATTERNS, 'data');
const createLogsContextService = async ({
  logsDataAccess
}) => {
  let allLogsIndexPattern;
  let logSources;
  if (logsDataAccess) {
    const logSourcesService = logsDataAccess.services.logSourcesService;
    allLogsIndexPattern = (await logSourcesService.getLogSources()).map(logSource => logSource.indexPattern).join(','); // TODO: Will be replaced by helper in: https://github.com/elastic/kibana/pull/192003
    logSources = allLogsIndexPattern.split(',');
  }
  const ALLOWED_LOGS_DATA_SOURCES = [DEFAULT_ALLOWED_LOGS_BASE_PATTERNS_REGEXP, ...(logSources ? logSources : [])];
  return getLogsContextService({
    allLogsIndexPattern,
    allowedDataSources: ALLOWED_LOGS_DATA_SOURCES
  });
};
exports.createLogsContextService = createLogsContextService;
const getLogsContextService = ({
  allLogsIndexPattern,
  allowedDataSources
}) => {
  const getAllLogsIndexPattern = () => allLogsIndexPattern;
  const isLogsIndexPattern = indexPattern => {
    return typeof indexPattern === 'string' && (0, _dataViewUtils.testPatternAgainstAllowedList)(allowedDataSources)(indexPattern);
  };
  return {
    getAllLogsIndexPattern,
    isLogsIndexPattern
  };
};
exports.getLogsContextService = getLogsContextService;