"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSearchEmbeddableFactory = void 0;
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _cellActions = require("@kbn/cell-actions");
var _public = require("@kbn/data-plugin/public");
var _discoverUtils = require("@kbn/discover-utils");
var _esQuery = require("@kbn/es-query");
var _i18n = require("@kbn/i18n");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _common = require("@kbn/saved-search-plugin/common");
var _get_valid_view_mode = require("../application/main/utils/get_valid_view_mode");
var _search_embeddable_field_stats_table_component = require("./components/search_embeddable_field_stats_table_component");
var _search_embeddable_grid_component = require("./components/search_embeddable_grid_component");
var _initialize_edit_api = require("./initialize_edit_api");
var _initialize_fetch = require("./initialize_fetch");
var _initialize_search_embeddable_api = require("./initialize_search_embeddable_api");
var _serialization_utils = require("./utils/serialization_utils");
var _context_awareness = require("../context_awareness");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getSearchEmbeddableFactory = ({
  startServices,
  discoverServices
}) => {
  const {
    save,
    checkForDuplicateTitle
  } = discoverServices.savedSearch;
  const savedSearchEmbeddableFactory = {
    type: _discoverUtils.SEARCH_EMBEDDABLE_TYPE,
    deserializeState: async serializedState => {
      return (0, _serialization_utils.deserializeState)({
        serializedState,
        discoverServices
      });
    },
    buildEmbeddable: async (initialState, buildApi, uuid, parentApi) => {
      var _initialState$nonPers, _initialState$nonPers2, _getRenderAppWrapper, _discoverServices$emb, _dynamicActionsApi$dy;
      /** One Discover context awareness */
      const solutionNavId = (_initialState$nonPers = (_initialState$nonPers2 = initialState.nonPersistedDisplayOptions) === null || _initialState$nonPers2 === void 0 ? void 0 : _initialState$nonPers2.solutionNavIdOverride) !== null && _initialState$nonPers !== void 0 ? _initialState$nonPers : await (0, _rxjs.firstValueFrom)(discoverServices.core.chrome.getActiveSolutionNavId$());
      const {
        getRenderAppWrapper
      } = await discoverServices.profilesManager.resolveRootProfile({
        solutionNavId
      });
      const AppWrapper = (_getRenderAppWrapper = getRenderAppWrapper === null || getRenderAppWrapper === void 0 ? void 0 : getRenderAppWrapper(_context_awareness.BaseAppWrapper)) !== null && _getRenderAppWrapper !== void 0 ? _getRenderAppWrapper : _context_awareness.BaseAppWrapper;

      /** Specific by-reference state */
      const savedObjectId$ = new _rxjs.BehaviorSubject(initialState === null || initialState === void 0 ? void 0 : initialState.savedObjectId);
      const defaultTitle$ = new _rxjs.BehaviorSubject(initialState === null || initialState === void 0 ? void 0 : initialState.savedObjectTitle);
      const defaultDescription$ = new _rxjs.BehaviorSubject(initialState === null || initialState === void 0 ? void 0 : initialState.savedObjectDescription);

      /** By-value SavedSearchComponent package (non-dashboard contexts) state, to adhere to the comparator contract of an embeddable. */
      const nonPersistedDisplayOptions$ = new _rxjs.BehaviorSubject(initialState === null || initialState === void 0 ? void 0 : initialState.nonPersistedDisplayOptions);

      /** All other state */
      const blockingError$ = new _rxjs.BehaviorSubject(undefined);
      const dataLoading$ = new _rxjs.BehaviorSubject(true);
      const fetchContext$ = new _rxjs.BehaviorSubject(undefined);
      const fetchWarnings$ = new _rxjs.BehaviorSubject([]);

      /** Build API */
      const titleManager = (0, _presentationPublishing.initializeTitleManager)(initialState);
      const timeRange = (0, _presentationPublishing.initializeTimeRange)(initialState);
      const dynamicActionsApi = (_discoverServices$emb = discoverServices.embeddableEnhanced) === null || _discoverServices$emb === void 0 ? void 0 : _discoverServices$emb.initializeReactEmbeddableDynamicActions(uuid, () => titleManager.api.title$.getValue(), initialState);
      const maybeStopDynamicActions = dynamicActionsApi === null || dynamicActionsApi === void 0 ? void 0 : dynamicActionsApi.startDynamicActions();
      const searchEmbeddable = await (0, _initialize_search_embeddable_api.initializeSearchEmbeddableApi)(initialState, {
        discoverServices
      });
      const unsubscribeFromFetch = (0, _initialize_fetch.initializeFetch)({
        api: {
          parentApi,
          ...titleManager.api,
          ...timeRange.api,
          savedSearch$: searchEmbeddable.api.savedSearch$,
          dataViews$: searchEmbeddable.api.dataViews$,
          savedObjectId$,
          dataLoading$,
          blockingError$,
          fetchContext$,
          fetchWarnings$
        },
        discoverServices,
        stateManager: searchEmbeddable.stateManager,
        setDataLoading: dataLoading => dataLoading$.next(dataLoading),
        setBlockingError: error => blockingError$.next(error)
      });
      const serialize = savedObjectId => (0, _serialization_utils.serializeState)({
        uuid,
        initialState,
        savedSearch: searchEmbeddable.api.savedSearch$.getValue(),
        serializeTitles: titleManager.serialize,
        serializeTimeRange: timeRange.serialize,
        serializeDynamicActions: dynamicActionsApi === null || dynamicActionsApi === void 0 ? void 0 : dynamicActionsApi.serializeDynamicActions,
        savedObjectId
      });
      const api = buildApi({
        ...titleManager.api,
        ...searchEmbeddable.api,
        ...timeRange.api,
        ...(dynamicActionsApi === null || dynamicActionsApi === void 0 ? void 0 : dynamicActionsApi.dynamicActionsApi),
        ...(0, _initialize_edit_api.initializeEditApi)({
          uuid,
          parentApi,
          partialApi: {
            ...searchEmbeddable.api,
            fetchContext$,
            savedObjectId$
          },
          discoverServices,
          isEditable: startServices.isEditable
        }),
        dataLoading$,
        blockingError$,
        savedObjectId$,
        defaultTitle$,
        defaultDescription$,
        hasTimeRange: () => {
          const fetchContext = fetchContext$.getValue();
          return (fetchContext === null || fetchContext === void 0 ? void 0 : fetchContext.timeslice) !== undefined || (fetchContext === null || fetchContext === void 0 ? void 0 : fetchContext.timeRange) !== undefined;
        },
        getTypeDisplayName: () => _i18n.i18n.translate('discover.embeddable.search.displayName', {
          defaultMessage: 'Discover session'
        }),
        canLinkToLibrary: async () => {
          return discoverServices.capabilities.discover_v2.save && !Boolean(savedObjectId$.getValue());
        },
        canUnlinkFromLibrary: async () => Boolean(savedObjectId$.getValue()),
        saveToLibrary: async title => {
          const savedObjectId = await save({
            ...api.savedSearch$.getValue(),
            title
          });
          defaultTitle$.next(title);
          return savedObjectId;
        },
        checkForDuplicateTitle: (newTitle, isTitleDuplicateConfirmed, onTitleDuplicate) => checkForDuplicateTitle({
          newTitle,
          isTitleDuplicateConfirmed,
          onTitleDuplicate
        }),
        getSerializedStateByValue: () => serialize(undefined),
        getSerializedStateByReference: newId => serialize(newId),
        serializeState: () => serialize(savedObjectId$.getValue()),
        getInspectorAdapters: () => searchEmbeddable.stateManager.inspectorAdapters.getValue(),
        supportedTriggers: () => {
          // No triggers are supported, but this is still required to pass the drilldown
          // compatibilty check and ensure top-level drilldowns (e.g. URL) work as expected
          return [];
        }
      }, {
        ...titleManager.comparators,
        ...timeRange.comparators,
        ...((_dynamicActionsApi$dy = dynamicActionsApi === null || dynamicActionsApi === void 0 ? void 0 : dynamicActionsApi.dynamicActionsComparator) !== null && _dynamicActionsApi$dy !== void 0 ? _dynamicActionsApi$dy : {
          enhancements: (0, _presentationPublishing.getUnchangingComparator)()
        }),
        ...searchEmbeddable.comparators,
        rawSavedObjectAttributes: (0, _presentationPublishing.getUnchangingComparator)(),
        savedObjectId: [savedObjectId$, value => savedObjectId$.next(value)],
        savedObjectTitle: [defaultTitle$, value => defaultTitle$.next(value)],
        savedObjectDescription: [defaultDescription$, value => defaultDescription$.next(value)],
        nonPersistedDisplayOptions: [nonPersistedDisplayOptions$, value => nonPersistedDisplayOptions$.next(value)]
      });
      return {
        api,
        Component: () => {
          var _initialState$nonPers3, _initialState$nonPers4, _initialState$nonPers5;
          const [savedSearch, dataViews] = (0, _presentationPublishing.useBatchedPublishingSubjects)(api.savedSearch$, api.dataViews$);
          (0, _react.useEffect)(() => {
            return () => {
              searchEmbeddable.cleanup();
              unsubscribeFromFetch();
              maybeStopDynamicActions === null || maybeStopDynamicActions === void 0 ? void 0 : maybeStopDynamicActions.stopDynamicActions();
            };
          }, []);
          const viewMode = (0, _react.useMemo)(() => {
            if (!savedSearch.searchSource) return;
            return (0, _get_valid_view_mode.getValidViewMode)({
              viewMode: savedSearch.viewMode,
              isEsqlMode: (0, _initialize_fetch.isEsqlMode)(savedSearch)
            });
          }, [savedSearch]);
          const dataView = (0, _react.useMemo)(() => {
            const hasDataView = (dataViews !== null && dataViews !== void 0 ? dataViews : []).length > 0;
            if (!hasDataView) {
              var _initialState$seriali, _initialState$seriali2, _initialState$seriali3, _initialState$seriali4;
              blockingError$.next(new Error(_i18n.i18n.translate('discover.embeddable.search.dataViewError', {
                defaultMessage: 'Missing data view {indexPatternId}',
                values: {
                  indexPatternId: typeof ((_initialState$seriali = initialState.serializedSearchSource) === null || _initialState$seriali === void 0 ? void 0 : _initialState$seriali.index) === 'string' ? initialState.serializedSearchSource.index : (_initialState$seriali2 = (_initialState$seriali3 = initialState.serializedSearchSource) === null || _initialState$seriali3 === void 0 ? void 0 : (_initialState$seriali4 = _initialState$seriali3.index) === null || _initialState$seriali4 === void 0 ? void 0 : _initialState$seriali4.id) !== null && _initialState$seriali2 !== void 0 ? _initialState$seriali2 : ''
                }
              })));
              return;
            }
            return dataViews[0];
          }, [dataViews]);
          const onAddFilter = (0, _react.useCallback)(async (field, value, operator) => {
            if (!dataView || !field) return;
            let newFilters = (0, _public.generateFilters)(discoverServices.filterManager, field, value, operator, dataView);
            newFilters = newFilters.map(filter => ({
              ...filter,
              $state: {
                store: _esQuery.FilterStateStore.APP_STATE
              }
            }));
            await startServices.executeTriggerActions(_public.APPLY_FILTER_TRIGGER, {
              embeddable: api,
              filters: newFilters
            });
          }, [dataView]);
          const renderAsFieldStatsTable = (0, _react.useMemo)(() => Boolean(discoverServices.uiSettings.get(_discoverUtils.SHOW_FIELD_STATISTICS)) && viewMode === _common.VIEW_MODE.AGGREGATED_LEVEL && Boolean(dataView) && Array.isArray(savedSearch.columns), [savedSearch, dataView, viewMode]);
          return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, discoverServices.core, /*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
            services: discoverServices
          }, /*#__PURE__*/_react.default.createElement(AppWrapper, null, renderAsFieldStatsTable ? /*#__PURE__*/_react.default.createElement(_search_embeddable_field_stats_table_component.SearchEmbeddablFieldStatsTableComponent, {
            api: {
              ...api,
              fetchContext$
            },
            dataView: dataView,
            onAddFilter: (0, _initialize_fetch.isEsqlMode)(savedSearch) ? undefined : onAddFilter,
            stateManager: searchEmbeddable.stateManager
          }) : /*#__PURE__*/_react.default.createElement(_cellActions.CellActionsProvider, {
            getTriggerCompatibleActions: discoverServices.uiActions.getTriggerCompatibleActions
          }, /*#__PURE__*/_react.default.createElement(_search_embeddable_grid_component.SearchEmbeddableGridComponent, {
            api: {
              ...api,
              fetchWarnings$,
              fetchContext$
            },
            dataView: dataView,
            onAddFilter: (0, _initialize_fetch.isEsqlMode)(savedSearch) || ((_initialState$nonPers3 = initialState.nonPersistedDisplayOptions) === null || _initialState$nonPers3 === void 0 ? void 0 : _initialState$nonPers3.enableFilters) === false ? undefined : onAddFilter,
            enableDocumentViewer: ((_initialState$nonPers4 = initialState.nonPersistedDisplayOptions) === null || _initialState$nonPers4 === void 0 ? void 0 : _initialState$nonPers4.enableDocumentViewer) !== undefined ? (_initialState$nonPers5 = initialState.nonPersistedDisplayOptions) === null || _initialState$nonPers5 === void 0 ? void 0 : _initialState$nonPers5.enableDocumentViewer : true,
            stateManager: searchEmbeddable.stateManager
          })))));
        }
      };
    }
  };
  return savedSearchEmbeddableFactory;
};
exports.getSearchEmbeddableFactory = getSearchEmbeddableFactory;