"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentType = exports.DocumentProfileService = void 0;
var _profile_service = require("../profile_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * Indicates the current document type (e.g. log, alert, etc.)
 */
let DocumentType = exports.DocumentType = /*#__PURE__*/function (DocumentType) {
  DocumentType["Log"] = "log";
  DocumentType["Default"] = "default";
  return DocumentType;
}({});
/**
 * The document profile interface
 */
/**
 * Parameters for the document profile provider `resolve` method
 */
/**
 * The resulting context object returned by the document profile provider `resolve` method
 */
class DocumentProfileService extends _profile_service.ProfileService {
  constructor() {
    super({
      profileId: 'default-document-profile',
      type: DocumentType.Default
    });
  }
}
exports.DocumentProfileService = DocumentProfileService;