"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverMainRoute = DiscoverMainRoute;
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/kibana-utils-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _public3 = require("@kbn/saved-search-plugin/public");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _ebtTools = require("@kbn/ebt-tools");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _esqlUtils = require("@kbn/esql-utils");
var _dataViewUtils = require("@kbn/data-view-utils");
var _use_url = require("./hooks/use_url");
var _use_discover_state_container = require("./hooks/use_discover_state_container");
var _discover_main_app = require("./discover_main_app");
var _breadcrumbs = require("../../utils/breadcrumbs");
var _loading_indicator = require("../../components/common/loading_indicator");
var _error_alert = require("../../components/common/error_alert");
var _use_discover_services = require("../../hooks/use_discover_services");
var _use_alert_results_toast = require("./hooks/use_alert_results_toast");
var _discover_state_provider = require("./state_management/discover_state_provider");
var _customizations = require("../../customizations");
var _data_sources = require("../../../common/data_sources");
var _context_awareness = require("../../context_awareness");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const DiscoverMainAppMemoized = /*#__PURE__*/(0, _react.memo)(_discover_main_app.DiscoverMainApp);
function DiscoverMainRoute({
  customizationCallbacks = [],
  customizationContext,
  stateStorageContainer
}) {
  const history = (0, _reactRouterDom.useHistory)();
  const services = (0, _use_discover_services.useDiscoverServices)();
  const {
    core,
    chrome,
    data,
    toastNotifications,
    http: {
      basePath
    },
    dataViewEditor,
    share,
    getScopedHistory
  } = services;
  const {
    id: savedSearchId
  } = (0, _reactRouterDom.useParams)();
  const [stateContainer, {
    reset: resetStateContainer
  }] = (0, _use_discover_state_container.useDiscoverStateContainer)({
    history,
    services,
    customizationContext,
    stateStorageContainer
  });
  const {
    customizationService,
    isInitialized: isCustomizationServiceInitialized
  } = (0, _customizations.useDiscoverCustomizationService)({
    customizationCallbacks,
    stateContainer
  });
  const [error, setError] = (0, _react.useState)();
  const [loading, setLoading] = (0, _react.useState)(true);
  const [noDataState, setNoDataState] = (0, _react.useState)({
    hasESData: false,
    hasUserDataView: false,
    showNoDataPage: false
  });
  const hasCustomBranding = (0, _useObservable.default)(core.customBranding.hasCustomBranding$, false);

  /**
   * Get location state of scoped history only on initial load
   */
  const historyLocationState = (0, _react.useMemo)(() => {
    var _getScopedHistory;
    return (_getScopedHistory = getScopedHistory()) === null || _getScopedHistory === void 0 ? void 0 : _getScopedHistory.location.state;
  }, [getScopedHistory]);
  (0, _use_alert_results_toast.useAlertResultsToast)({
    isAlertResults: historyLocationState === null || historyLocationState === void 0 ? void 0 : historyLocationState.isAlertResults,
    toastNotifications
  });
  (0, _public2.useExecutionContext)(core.executionContext, {
    type: 'application',
    page: 'app',
    id: savedSearchId || 'new'
  });
  /**
   * Helper function to determine when to skip the no data page
   */
  const skipNoDataPage = (0, _react.useCallback)(async nextDataView => {
    try {
      const {
        dataSource
      } = stateContainer.appState.getState();
      const isEsqlQuery = (0, _data_sources.isDataSourceType)(dataSource, _data_sources.DataSourceType.Esql);
      if (savedSearchId || isEsqlQuery || nextDataView) {
        // Although ES|QL doesn't need a data view, we still need to load the data view list to
        // ensure the data view is available for the user to switch to classic mode
        await stateContainer.actions.loadDataViewList();
        return true;
      }
      const [hasUserDataViewValue, hasESDataValue, defaultDataViewExists] = await Promise.all([data.dataViews.hasData.hasUserDataView().catch(() => false), data.dataViews.hasData.hasESData().catch(() => false), data.dataViews.defaultDataViewExists().catch(() => false), stateContainer.actions.loadDataViewList()]);
      const persistedDataViewsExist = hasUserDataViewValue && defaultDataViewExists;
      const adHocDataViewsExist = stateContainer.internalState.getState().adHocDataViews.length > 0;
      const locationStateHasDataViewSpec = Boolean(historyLocationState === null || historyLocationState === void 0 ? void 0 : historyLocationState.dataViewSpec);
      const canAccessWithAdHocDataViews = hasESDataValue && (adHocDataViewsExist || locationStateHasDataViewSpec);
      if (persistedDataViewsExist || canAccessWithAdHocDataViews) {
        return true;
      }
      setNoDataState({
        showNoDataPage: true,
        hasESData: hasESDataValue,
        hasUserDataView: hasUserDataViewValue
      });
      return false;
    } catch (e) {
      setError(e);
      return false;
    }
  }, [data.dataViews, historyLocationState === null || historyLocationState === void 0 ? void 0 : historyLocationState.dataViewSpec, savedSearchId, stateContainer]);
  const loadSavedSearch = (0, _react.useCallback)(async ({
    nextDataView,
    initialAppState
  } = {}) => {
    const loadSavedSearchStartTime = window.performance.now();
    setLoading(true);
    const skipNoData = await skipNoDataPage(nextDataView);
    if (!skipNoData) {
      setLoading(false);
      return;
    }
    try {
      const currentSavedSearch = await stateContainer.actions.loadSavedSearch({
        savedSearchId,
        dataView: nextDataView,
        dataViewSpec: historyLocationState === null || historyLocationState === void 0 ? void 0 : historyLocationState.dataViewSpec,
        initialAppState
      });
      if (customizationContext.displayMode === 'standalone') {
        var _currentSavedSearch$t2;
        if (currentSavedSearch !== null && currentSavedSearch !== void 0 && currentSavedSearch.id) {
          var _currentSavedSearch$t;
          chrome.recentlyAccessed.add((0, _public3.getSavedSearchFullPathUrl)(currentSavedSearch.id), (_currentSavedSearch$t = currentSavedSearch.title) !== null && _currentSavedSearch$t !== void 0 ? _currentSavedSearch$t : '', currentSavedSearch.id);
        }
        (0, _breadcrumbs.setBreadcrumbs)({
          services,
          titleBreadcrumbText: (_currentSavedSearch$t2 = currentSavedSearch === null || currentSavedSearch === void 0 ? void 0 : currentSavedSearch.title) !== null && _currentSavedSearch$t2 !== void 0 ? _currentSavedSearch$t2 : undefined
        });
      }
      setLoading(false);
      if (services.analytics) {
        const loadSavedSearchDuration = window.performance.now() - loadSavedSearchStartTime;
        (0, _ebtTools.reportPerformanceMetricEvent)(services.analytics, {
          eventName: 'discoverLoadSavedSearch',
          duration: loadSavedSearchDuration
        });
      }
    } catch (e) {
      if (e instanceof _public.SavedObjectNotFound) {
        (0, _public.redirectWhenMissing)({
          history,
          navigateToApp: core.application.navigateToApp,
          basePath,
          mapping: {
            search: '/',
            'index-pattern': {
              app: 'management',
              path: `kibana/objects/savedSearches/${savedSearchId}`
            }
          },
          toastNotifications,
          onBeforeRedirect() {
            services.urlTracker.setTrackedUrl('/');
          },
          ...core
        })(e);
      } else {
        setError(e);
      }
    }
  }, [skipNoDataPage, stateContainer, savedSearchId, historyLocationState === null || historyLocationState === void 0 ? void 0 : historyLocationState.dataViewSpec, customizationContext.displayMode, services, chrome.recentlyAccessed, history, core, basePath, toastNotifications]);
  const rootProfileState = (0, _context_awareness.useRootProfile)();
  const {
    initializeProfileDataViews
  } = (0, _context_awareness.useDefaultAdHocDataViews)({
    stateContainer,
    rootProfileState
  });
  (0, _react.useEffect)(() => {
    if (!isCustomizationServiceInitialized || rootProfileState.rootProfileLoading) {
      return;
    }
    const load = async () => {
      setLoading(true);
      setNoDataState({
        hasESData: false,
        hasUserDataView: false,
        showNoDataPage: false
      });
      setError(undefined);
      await initializeProfileDataViews();
      if (savedSearchId) {
        await loadSavedSearch();
      } else {
        // restore the previously selected data view for a new state (when a saved search was open)
        await loadSavedSearch(getLoadParamsForNewSearch(stateContainer));
      }
    };
    load();
  }, [initializeProfileDataViews, isCustomizationServiceInitialized, loadSavedSearch, rootProfileState.rootProfileLoading, savedSearchId, stateContainer]);

  // secondary fetch: in case URL is set to `/`, used to reset to 'new' state, keeping the current data view
  (0, _use_url.useUrl)({
    history,
    savedSearchId,
    onNewUrl: () => {
      // restore the previously selected data view for a new state
      loadSavedSearch(getLoadParamsForNewSearch(stateContainer));
    }
  });
  const onDataViewCreated = (0, _react.useCallback)(async nextDataView => {
    if (nextDataView) {
      setLoading(true);
      setNoDataState(state => ({
        ...state,
        showNoDataPage: false
      }));
      setError(undefined);
      await loadSavedSearch({
        nextDataView: nextDataView
      });
    }
  }, [loadSavedSearch]);
  const onESQLNavigationComplete = (0, _react.useCallback)(async () => {
    resetStateContainer();
  }, [resetStateContainer]);
  const noDataDependencies = (0, _react.useMemo)(() => ({
    coreStart: core,
    dataViews: {
      ...data.dataViews,
      hasData: {
        ...data.dataViews.hasData,
        // We've already called this, so we can optimize the analytics services to
        // use the already-retrieved data to avoid a double-call.
        hasESData: () => Promise.resolve(noDataState.hasESData),
        hasUserDataView: () => Promise.resolve(noDataState.hasUserDataView)
      }
    },
    share,
    dataViewEditor,
    noDataPage: services.noDataPage
  }), [core, data.dataViews, dataViewEditor, noDataState, services.noDataPage, share]);
  const loadingIndicator = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_loading_indicator.LoadingIndicator, {
    type: hasCustomBranding ? 'spinner' : 'elastic'
  }), [hasCustomBranding]);
  const mainContent = (0, _react.useMemo)(() => {
    if (noDataState.showNoDataPage) {
      const importPromise = Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/shared-ux-page-analytics-no-data')));
      const AnalyticsNoDataPageKibanaProvider = (0, _sharedUxUtility.withSuspense)(/*#__PURE__*/_react.default.lazy(() => importPromise.then(({
        AnalyticsNoDataPageKibanaProvider: NoDataProvider
      }) => {
        return {
          default: NoDataProvider
        };
      })));
      const AnalyticsNoDataPage = (0, _sharedUxUtility.withSuspense)(/*#__PURE__*/_react.default.lazy(() => importPromise.then(({
        AnalyticsNoDataPage: NoDataPage
      }) => {
        return {
          default: NoDataPage
        };
      })));
      return /*#__PURE__*/_react.default.createElement(AnalyticsNoDataPageKibanaProvider, noDataDependencies, /*#__PURE__*/_react.default.createElement(AnalyticsNoDataPage, {
        onDataViewCreated: onDataViewCreated,
        onESQLNavigationComplete: onESQLNavigationComplete
      }));
    }
    if (loading) {
      return loadingIndicator;
    }
    return /*#__PURE__*/_react.default.createElement(DiscoverMainAppMemoized, {
      stateContainer: stateContainer
    });
  }, [loading, loadingIndicator, noDataDependencies, onDataViewCreated, onESQLNavigationComplete, noDataState.showNoDataPage, stateContainer]);
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_error_alert.DiscoverError, {
      error: error
    });
  }
  if (!customizationService || rootProfileState.rootProfileLoading) {
    return loadingIndicator;
  }
  return /*#__PURE__*/_react.default.createElement(_customizations.DiscoverCustomizationProvider, {
    value: customizationService
  }, /*#__PURE__*/_react.default.createElement(_discover_state_provider.DiscoverMainProvider, {
    value: stateContainer
  }, /*#__PURE__*/_react.default.createElement(rootProfileState.AppWrapper, null, mainContent)));
}
// eslint-disable-next-line import/no-default-export
var _default = exports.default = DiscoverMainRoute;
function getLoadParamsForNewSearch(stateContainer) {
  const prevAppState = stateContainer.appState.getState();
  const prevDataView = stateContainer.internalState.getState().dataView;
  const initialAppState = (0, _data_sources.isDataSourceType)(prevAppState.dataSource, _data_sources.DataSourceType.Esql) && prevDataView && prevDataView.type === _dataViewUtils.ESQL_TYPE ? {
    // reset to a default ES|QL query
    query: {
      esql: (0, _esqlUtils.getInitialESQLQuery)(prevDataView)
    }
  } : undefined;
  return {
    nextDataView: prevDataView,
    initialAppState
  };
}