"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDatasetQualityDetailsControllerFactory = void 0;
var _xstateUtils = require("@kbn/xstate-utils");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _rxjs = require("rxjs");
var _xstate = require("xstate");
var _state_machine = require("../../state_machines/dataset_quality_details_controller/state_machine");
var _public_state = require("./public_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createDatasetQualityDetailsControllerFactory = ({
  core,
  plugins,
  dataStreamStatsService,
  dataStreamDetailsService,
  isFailureStoreEnabled
}) => async ({
  initialState
}) => {
  const initialContext = (0, _public_state.getContextFromPublicState)(initialState);
  const [dataStreamStatsClient, dataStreamDetailsClient] = await Promise.all([dataStreamStatsService.getClient(), dataStreamDetailsService.getClient()]);
  const machine = (0, _state_machine.createDatasetQualityDetailsControllerStateMachine)({
    initialContext,
    plugins,
    toasts: core.notifications.toasts,
    dataStreamStatsClient,
    dataStreamDetailsClient,
    isFailureStoreEnabled
  });
  const service = (0, _xstate.interpret)(machine, {
    devTools: (0, _xstateUtils.getDevToolsOptions)()
  });
  const state$ = (0, _rxjs.from)(service).pipe((0, _rxjs.map)(({
    context
  }) => (0, _public_state.getPublicStateFromContext)(context)), (0, _rxjs.distinctUntilChanged)(_fastDeepEqual.default));
  return {
    state$,
    service
  };
};
exports.createDatasetQualityDetailsControllerFactory = createDatasetQualityDetailsControllerFactory;