"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FailedFieldInfo = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _translations = require("../../../../../common/translations");
var _hooks = require("../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const failedDocsErrorsTableNoData = _i18n.i18n.translate('xpack.datasetQuality.details.qualityIssue.failedDocs.erros.noData', {
  defaultMessage: 'No errors found'
});
const FailedFieldInfo = () => {
  const {
    isDegradedFieldsLoading,
    failedDocsErrorsColumns,
    renderedFailedDocsErrorsItems,
    failedDocsErrorsSort,
    isFailedDocsErrorsLoading,
    resultsCount,
    failedDocsErrorsPagination,
    onFailedDocsErrorsTableChange
  } = (0, _hooks.useQualityIssues)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": `datasetQualityDetailsDegradedFieldFlyoutFieldsList-cause`,
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("span", null, _translations.failedDocsErrorsColumnName))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "datasetQualityDetailsDegradedFieldFlyoutFieldValue-cause",
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.datasetQuality.qualityIssueFlyout.table",
    defaultMessage: "Showing {items}",
    values: {
      items: resultsCount
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    tableLayout: "fixed",
    columns: failedDocsErrorsColumns,
    items: renderedFailedDocsErrorsItems !== null && renderedFailedDocsErrorsItems !== void 0 ? renderedFailedDocsErrorsItems : [],
    loading: isFailedDocsErrorsLoading,
    sorting: failedDocsErrorsSort,
    onChange: onFailedDocsErrorsTableChange,
    "data-test-subj": "datasetQualityDetailsDegradedFieldTable",
    rowProps: {
      'data-test-subj': 'datasetQualityDetailsDegradedTableRow'
    },
    noItemsMessage: isDegradedFieldsLoading ? _translations.overviewDegradedFieldsTableLoadingText : failedDocsErrorsTableNoData,
    pagination: failedDocsErrorsPagination
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  })));
};
exports.FailedFieldInfo = FailedFieldInfo;